/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.auth;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.UUID;
import org.codehaus.commons.compiler.util.Producer;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.components.auth.AbstractAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.components.auth.RequestAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyRequest;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyResponse;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.BasicAuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.auth.OAuth2AuthrizationResponse;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BasicRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.qubership.atp.itf.lite.backend.utils.AuthorizationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class BasicRequestAuthorizationStrategy
extends AbstractAuthorizationStrategy
implements RequestAuthorizationStrategy {
    private static final Logger log = LoggerFactory.getLogger(BasicRequestAuthorizationStrategy.class);
    private Base64.Encoder base64Encoder = Base64.getEncoder();

    public BasicRequestAuthorizationStrategy(EncryptionService encryptionService) {
        super(encryptionService);
    }

    @Override
    public AuthorizationStrategyResponse getAuthorizationToken(AuthorizationStrategyRequest request) throws AtpDecryptException {
        log.debug("Get authorization token for request");
        BasicAuthorizationSaveRequest authorization = (BasicAuthorizationSaveRequest)request.getUnsafeAuthorizationRequest();
        String authHeader = this.generateAuthHeaderValue(authorization);
        log.debug("Result Authorization header: {}", (Object)authHeader);
        return new AuthorizationStrategyResponse(authHeader, authHeader);
    }

    private String generateAuthHeaderValue(BasicAuthorizationSaveRequest authorization) {
        this.decryptParameters(authorization);
        this.decodeParameters(authorization);
        this.decryptParameters(authorization);
        String username = authorization.getUsername();
        String password = authorization.getPassword();
        String toEncode = username + ":" + password;
        return "Basic " + this.base64Encoder.encodeToString(toEncode.getBytes(StandardCharsets.UTF_8));
    }

    public void decodeParameters(AuthorizationSaveRequest authorization) {
        log.debug("Decode authorization parameters");
        BasicAuthorizationSaveRequest oAuth2Authorization = (BasicAuthorizationSaveRequest)authorization;
        this.decodeParameter((Producer<String>)((Producer)oAuth2Authorization::getPassword), oAuth2Authorization::setPassword);
        log.debug("Password has been successfully decoded");
    }

    @Override
    public void decryptParameters(AuthorizationSaveRequest authorization) {
        log.debug("Decrypt authorization parameters");
        BasicAuthorizationSaveRequest basicAuthSaveRequest = (BasicAuthorizationSaveRequest)authorization;
        this.decryptParameter((Producer<String>)((Producer)basicAuthSaveRequest::getUsername), basicAuthSaveRequest::setUsername);
        log.debug("Password has been successfully decrypted");
        this.decryptParameter((Producer<String>)((Producer)basicAuthSaveRequest::getPassword), basicAuthSaveRequest::setPassword);
        log.debug("Client secret has been successfully decrypted");
    }

    @Override
    public void encryptParameters(AuthorizationSaveRequest authorization) {
        log.debug("Encrypt authorization parameters");
        BasicAuthorizationSaveRequest basicAuthSaveRequest = (BasicAuthorizationSaveRequest)authorization;
        this.encryptParameter((Producer<String>)((Producer)basicAuthSaveRequest::getUsername), basicAuthSaveRequest::setUsername);
        log.debug("Password has been successfully encrypted");
        this.encryptParameter((Producer<String>)((Producer)basicAuthSaveRequest::getPassword), basicAuthSaveRequest::setPassword);
        log.debug("Client secret has been successfully encrypted");
    }

    @Override
    public OAuth2AuthrizationResponse performAuthorization(UUID projectId, String url, MultiValueMap<String, String> map) {
        return null;
    }

    @Override
    public RequestAuthorizationType getAuthorizationType() {
        return RequestAuthorizationType.BASIC;
    }

    @Override
    public RequestAuthorization parseAuthorizationFromMap(Map<String, String> authorizationInfo) {
        BasicRequestAuthorization basicRequestAuthorization = new BasicRequestAuthorization();
        basicRequestAuthorization.setType(RequestAuthorizationType.BASIC);
        if (authorizationInfo.containsKey("username")) {
            basicRequestAuthorization.setUsername(authorizationInfo.get("username"));
        }
        if (authorizationInfo.containsKey("password")) {
            basicRequestAuthorization.setPassword(authorizationInfo.get("password"));
        }
        return basicRequestAuthorization;
    }

    @Override
    public RequestHeader generateAuthorizationHeader(RequestAuthorization authorization) {
        BasicAuthorizationSaveRequest basicAuthorization = (BasicAuthorizationSaveRequest)AuthorizationUtils.castToAuthorizationSaveRequest(authorization);
        String headerValue = this.generateAuthHeaderValue(basicAuthorization);
        return new RequestHeader(null, "Authorization", headerValue, "", false, true);
    }
}

