/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.auth;

import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.components.auth.AbstractAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.components.auth.RequestAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyRequest;
import org.qubership.atp.itf.lite.backend.model.AuthorizationStrategyResponse;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.BearerAuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.auth.OAuth2AuthrizationResponse;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BearerRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.qubership.atp.itf.lite.backend.utils.AuthorizationUtils;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;

@Component
public class BearerAuthorizationStrategy
extends AbstractAuthorizationStrategy
implements RequestAuthorizationStrategy {
    private static final String BEARER_PREFIX = "Bearer ";

    public BearerAuthorizationStrategy(EncryptionService encryptionService) {
        super(encryptionService);
    }

    @Override
    public AuthorizationStrategyResponse getAuthorizationToken(AuthorizationStrategyRequest request) throws AtpDecryptException {
        BearerAuthorizationSaveRequest unsafeBearerAuthorization = (BearerAuthorizationSaveRequest)request.getUnsafeAuthorizationRequest();
        BearerAuthorizationSaveRequest safeBearerAuthorization = (BearerAuthorizationSaveRequest)request.getSafeAuthorizationRequest();
        return new AuthorizationStrategyResponse(this.getBearerToken(unsafeBearerAuthorization), this.getBearerToken(safeBearerAuthorization));
    }

    @Override
    public void encryptParameters(AuthorizationSaveRequest requestAuthorization) {
    }

    @Override
    public void decryptParameters(AuthorizationSaveRequest requestAuthorization) {
    }

    @Override
    public OAuth2AuthrizationResponse performAuthorization(UUID projectId, String url, MultiValueMap<String, String> map) {
        return null;
    }

    @Override
    public RequestAuthorizationType getAuthorizationType() {
        return RequestAuthorizationType.BEARER;
    }

    @Override
    public RequestAuthorization parseAuthorizationFromMap(Map<String, String> authorizationInfo) {
        BearerRequestAuthorization bearerRequestAuthorization = new BearerRequestAuthorization();
        bearerRequestAuthorization.setType(RequestAuthorizationType.BEARER);
        if (authorizationInfo.containsKey("token")) {
            bearerRequestAuthorization.setToken(authorizationInfo.get("token"));
        }
        if (bearerRequestAuthorization.getToken() == null || bearerRequestAuthorization.getToken().equals("")) {
            return null;
        }
        return bearerRequestAuthorization;
    }

    private String getBearerToken(BearerAuthorizationSaveRequest bearerAuthorizationSaveRequest) {
        if (bearerAuthorizationSaveRequest != null) {
            return BEARER_PREFIX + bearerAuthorizationSaveRequest.getToken();
        }
        return null;
    }

    @Override
    @Nullable
    public RequestHeader generateAuthorizationHeader(RequestAuthorization authorization) {
        BearerAuthorizationSaveRequest bearerAuthorization = (BearerAuthorizationSaveRequest)AuthorizationUtils.castToAuthorizationSaveRequest(authorization);
        String headerValue = this.getBearerToken(bearerAuthorization);
        return new RequestHeader(null, "Authorization", headerValue, "", false, true);
    }
}

