/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.auth;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import org.qubership.atp.itf.lite.backend.components.auth.RequestAuthorizationStrategy;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class RequestAuthorizationRegistry {
    private static final Logger log = LoggerFactory.getLogger(RequestAuthorizationRegistry.class);
    private final List<RequestAuthorizationStrategy> strategies;
    private Map<RequestAuthorizationType, RequestAuthorizationStrategy> strategiesMap;

    @PostConstruct
    public void lookupStrategies() {
        this.strategiesMap = this.strategies.stream().collect(Collectors.toMap(RequestAuthorizationStrategy::getAuthorizationType, Function.identity()));
    }

    public RequestAuthorizationStrategy getRequestAuthorizationStrategy(RequestAuthorizationType type) {
        if (Objects.isNull((Object)type) || !this.strategiesMap.containsKey((Object)type)) {
            String errMsg = String.format("Failed to find request authorization strategy implementation for auth type: %s", new Object[]{type});
            log.error(errMsg);
            throw new IllegalArgumentException(errMsg);
        }
        return this.strategiesMap.get((Object)type);
    }

    public RequestAuthorizationRegistry(List<RequestAuthorizationStrategy> strategies) {
        this.strategies = strategies;
    }
}

