/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.export.strategies;

import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.itf.lite.backend.ei.ServiceScopeEntities;

public interface ExportStrategy {
    public ExportFormat getFormat();

    public void export(ExportImportData var1, Path var2);

    default public void exportFolders(ExportImportData exportData, Path workDir) throws ExportException {
        Set exportFolderIds = ((Set)exportData.getExportScope().getEntities().getOrDefault(ServiceScopeEntities.ENTITY_ITF_LITE_FOLDERS.getValue(), new HashSet())).stream().map(UUID::fromString).collect(Collectors.toSet());
        ((Set)exportData.getExportScope().getEntities().getOrDefault("projects", new HashSet())).forEach(projectId -> this.exportFolders(exportFolderIds, workDir, UUID.fromString(projectId)));
    }

    public void exportFolders(Set<UUID> var1, Path var2, UUID var3);

    default public void exportRequests(ExportImportData exportData, Path workDir) throws ExportException {
        this.exportRequests(exportData, workDir, ((Set)exportData.getExportScope().getEntities().getOrDefault(ServiceScopeEntities.ENTITY_ITF_LITE_REQUESTS.getValue(), new HashSet())).stream().map(UUID::fromString).collect(Collectors.toSet()));
    }

    public void exportRequests(ExportImportData var1, Path var2, Set<UUID> var3) throws ExportException;
}

