/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.export.strategies;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.qubership.atp.ei.node.dto.ExportFormat;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.exceptions.ExportException;
import org.qubership.atp.ei.node.services.FileService;
import org.qubership.atp.ei.node.services.ObjectSaverToDiskService;
import org.qubership.atp.itf.lite.backend.components.export.strategies.ExportStrategy;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.FolderRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestRepository;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanBody;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanFile;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanItem;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanMode;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanModel;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileInfo;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class PostmanExportStrategy
implements ExportStrategy {
    private static final Logger log = LoggerFactory.getLogger(PostmanExportStrategy.class);
    private final RequestRepository requestRepository;
    private final FolderRepository folderRepository;
    private final ObjectSaverToDiskService objectSaverToDiskService;
    private final FileService fileService;
    private final GridFsService gridFsService;

    @Override
    public ExportFormat getFormat() {
        return ExportFormat.POSTMAN;
    }

    @Override
    public void export(ExportImportData exportData, Path path) {
        this.exportFolders(exportData, path);
        this.exportRequests(exportData, path);
    }

    @Override
    public void exportFolders(Set<UUID> exportFolderIds, Path workDir, UUID projectId) {
        List<Folder> folders = this.folderRepository.findAllByIdInOrderByOrder(exportFolderIds);
        if (!CollectionUtils.isEmpty(folders)) {
            folders.forEach(folder -> {
                ToPostmanModel postmanModel = new ToPostmanModel((Folder)folder);
                this.exportChildFoldersToPostman((Folder)folder, postmanModel.getItems(), projectId, workDir);
                this.objectSaverToDiskService.writeAtpEntityToFile(folder.getName() + "." + "collection", (Object)postmanModel, "collection", workDir, true);
            });
        }
    }

    @Override
    public void exportRequests(ExportImportData exportData, Path workDir, Set<UUID> exportRequestIds) throws ExportException {
        UUID projectId;
        List<Request> requests;
        if (!exportRequestIds.isEmpty() && (requests = this.requestRepository.findAllByProjectIdAndIdInOrderByOrder(projectId = exportData.getProjectId(), exportRequestIds)) != null && !(requests = requests.stream().filter(r -> r.getFolderId() == null).collect(Collectors.toList())).isEmpty()) {
            String folderName = "ATP_ITF_LITE_ROOT_REQUESTS";
            ToPostmanModel postmanModel = new ToPostmanModel(folderName);
            this.exportRequestsToPostman(requests, postmanModel.getItems(), workDir);
            this.objectSaverToDiskService.writeAtpEntityToFile(folderName + "." + "collection", (Object)postmanModel, "collection", workDir, true);
        }
    }

    private void exportChildFoldersToPostman(Folder parentFolder, List<ToPostmanItem> item, UUID projectId, Path workDir) {
        List<Folder> childFolders = this.folderRepository.findAllByProjectIdAndParentIdOrderByOrder(projectId, parentFolder.getId());
        if (childFolders != null && !childFolders.isEmpty()) {
            childFolders.forEach(folder -> {
                ToPostmanItem childItem = new ToPostmanItem((Folder)folder);
                item.add(childItem);
                this.exportChildFoldersToPostman((Folder)folder, childItem.getItems(), projectId, workDir);
            });
        }
        this.exportRequestsToPostman(this.requestRepository.findAllByFolderIdOrderByOrder(parentFolder.getId()), item, workDir);
    }

    private void exportRequestsToPostman(List<Request> requests, List<ToPostmanItem> item, Path workDir) {
        if (requests != null && !requests.isEmpty()) {
            requests.forEach(request -> {
                if (request instanceof HttpRequest) {
                    ToPostmanItem requestToPostman = new ToPostmanItem((HttpRequest)request);
                    Path workDirForFiles = workDir.resolve("collection").resolve("Files");
                    this.fileService.createDirectory(workDirForFiles);
                    ToPostmanBody body = requestToPostman.getRequest().getBody();
                    if (body != null) {
                        ToPostmanMode mode = body.getMode();
                        if (ToPostmanMode.FILE.equals((Object)mode)) {
                            body.setFile(this.exportBinaryFileToPostman(request.getId(), workDirForFiles));
                        }
                        if (ToPostmanMode.FORMDATA.equals((Object)mode)) {
                            this.exportFormDataFilesToPostman(request.getId(), workDirForFiles);
                        }
                    }
                    item.add(requestToPostman);
                }
            });
        }
    }

    private ToPostmanFile exportBinaryFileToPostman(UUID requestId, Path workDir) {
        log.info("Start export binary files to POSTMAN for request {}", (Object)requestId);
        FileInfo fileInfo = this.gridFsService.getFileInfoByRequestId(requestId);
        Path requestPath = workDir.resolve(requestId.toString());
        this.fileService.createDirectory(requestPath);
        String fileName = fileInfo.getFileName();
        Path filePath = requestPath.resolve(fileName);
        ToPostmanFile toPostmanFile = new ToPostmanFile("collection/Files/" + requestId + "/" + fileName);
        try (InputStream in = this.gridFsService.getFileByFileInfo(fileInfo);){
            Files.copy(in, filePath, new CopyOption[0]);
        }
        catch (IOException e) {
            log.error("Error when writing file {} for Request {} to the file system.", new Object[]{fileName, requestId, e});
        }
        log.info("End export files for requests {}", (Object)requestId);
        return toPostmanFile;
    }

    private void exportFormDataFilesToPostman(UUID requestId, Path workDir) {
        log.info("Start export form data files to POSTMAN for request {}", (Object)requestId);
        Path requestPath = workDir.resolve(requestId.toString());
        this.fileService.createDirectory(requestPath);
        this.gridFsService.getFileInfosByRequestId(requestId).forEach(fileInfo -> {
            String fileName = fileInfo.getFileName();
            Path filePath = requestPath.resolve(fileName);
            try (InputStream in = this.gridFsService.getFileByFileInfo((FileInfo)fileInfo);){
                Files.copy(in, filePath, new CopyOption[0]);
            }
            catch (IOException e) {
                log.error("Error when writing file {} for Request {} to the file system.", new Object[]{fileName, requestId, e});
            }
        });
        log.info("End export files for requests {}", (Object)requestId);
    }

    public PostmanExportStrategy(RequestRepository requestRepository, FolderRepository folderRepository, ObjectSaverToDiskService objectSaverToDiskService, FileService fileService, GridFsService gridFsService) {
        this.requestRepository = requestRepository;
        this.folderRepository = folderRepository;
        this.objectSaverToDiskService = objectSaverToDiskService;
        this.fileService = fileService;
        this.gridFsService = gridFsService;
    }
}

