/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.export.strategies.request;

import java.net.URISyntaxException;
import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.itf.lite.backend.components.export.strategies.request.MiaAbstractRequestExportStrategy;
import org.qubership.atp.itf.lite.backend.enums.ImportToolType;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestExportRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestMiaExportRequest;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.service.kafka.KafkaExportEventSendingService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class MiaRestRequestExportStrategy
extends MiaAbstractRequestExportStrategy {
    private static final Logger log = LoggerFactory.getLogger(MiaRestRequestExportStrategy.class);

    public MiaRestRequestExportStrategy(KafkaExportEventSendingService kafkaExportEventSendingService, RequestService requestService, ModelMapper modelMapper) {
        super(kafkaExportEventSendingService, requestService, modelMapper);
    }

    @Override
    public void export(UUID exportRequestId, RequestExportRequest exportRequest, Request request, String context, UUID environmentId) throws URISyntaxException, AtpDecryptException {
        this.sendExportRequestEvent(exportRequestId, (RequestMiaExportRequest)exportRequest, request, context);
    }

    @Override
    public TransportType getRequestTransportType() {
        return TransportType.REST;
    }

    @Override
    public ImportToolType getImportToolType() {
        return ImportToolType.MIA;
    }
}

