/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.components.replacer;

import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestEnvironmentNotSpecifiedException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestEnvironmentVariableNotFoundException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteRequestVariableReplacingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class EnvironmentReplacer {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentReplacer.class);
    private static final String envName = "name";
    private static final Pattern envPattern = Pattern.compile("\\$\\{(?i)ENV\\.(?<name>[^}]+)\\}");

    public String replace(String text, Map<String, Object> context) {
        Matcher matcher = envPattern.matcher(text);
        while (matcher.find()) {
            if (Objects.isNull(context)) {
                log.error("Found environment variable {}, but environment not specified in request", (Object)matcher.group(0));
                throw new ItfLiteRequestEnvironmentNotSpecifiedException();
            }
            text = this.replace(matcher, text, context);
        }
        return text;
    }

    public String replace(Matcher matcher, String value, Map<String, Object> context) {
        String environmentName = matcher.group(envName).toLowerCase();
        if (context.containsKey(environmentName)) {
            try {
                Object envValue = context.get(environmentName);
                String envValueStr = "null";
                if (Objects.nonNull(envValue)) {
                    envValueStr = envValue.toString();
                }
                value = value.replace(matcher.group(0), envValueStr);
                return value;
            }
            catch (RuntimeException ex) {
                String message = String.format("Error occurred while injecting environment [%s].\n%s\n%s", matcher.group(0), ex.getClass().getName(), ex.getMessage());
                log.error(message);
                throw new ItfLiteRequestVariableReplacingException(matcher.group(0), ex);
            }
        }
        log.error("Found environment variable {}, but environment does not contain such a variable", (Object)matcher.group(0));
        throw new ItfLiteRequestEnvironmentVariableNotFoundException(matcher.group(0));
    }
}

