/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.configuration;

import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class RamServiceConfiguration {
    private static final Logger log = LoggerFactory.getLogger(RamServiceConfiguration.class);
    @Value(value="${atp.catalogue.frontend.url:}")
    private String catalogueUrl;
    @Value(value="${feign.atp.ram.route:api/atp-ram/v1}")
    private String ramPrefix;
    @Value(value="${atp.service.internal:true}")
    private boolean isInternalGateWayEnabled;

    @Bean(value={"fileDownloadLink"})
    public String fileDownloadLink() {
        String fileDownloadLink = "";
        if (this.catalogueUrl != null && !this.catalogueUrl.isEmpty()) {
            log.debug("InternalGateway is Enabled & setting the file download URL prefix");
            try {
                fileDownloadLink = new URI(this.catalogueUrl + "/redirect-uri/" + this.ramPrefix).normalize().toString();
            }
            catch (URISyntaxException e) {
                log.error("Problem in download file URL Prefix Formation. {}", (Object)e.getMessage());
            }
            log.info("File download URL Prefix set to {}", (Object)fileDownloadLink);
        } else {
            log.error("Invalid atp-catalog URL. Please set environment variable ATP_CATALOGUE_URL");
        }
        return fileDownloadLink;
    }
}

