/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.configuration;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import liquibase.integration.spring.SpringLiquibase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.ResourceLoader;

public class SpringLiquibaseBeanAware
extends SpringLiquibase {
    private static final Logger log = LoggerFactory.getLogger(SpringLiquibaseBeanAware.class);
    @SuppressFBWarnings(value={"ST_WRITE_TO_STATIC_FROM_INSTANCE_METHOD"})
    private static ResourceLoader applicationContext;

    public static <T> T getBean(Class<T> beanClass) {
        if (ApplicationContext.class.isInstance(applicationContext)) {
            return (T)((ApplicationContext)applicationContext).getBean(beanClass);
        }
        log.error("Resource loader is not an instance of ApplicationContext");
        throw new IllegalStateException("Resource loader is not an instance of ApplicationContext");
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
        applicationContext = resourceLoader;
    }
}

