/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.configuration;

import java.util.HashMap;
import javax.sql.DataSource;
import liquibase.integration.spring.SpringLiquibase;
import org.qubership.atp.itf.lite.backend.configuration.SpringLiquibaseBeanAware;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.liquibase.LiquibaseProperties;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@EnableConfigurationProperties(value={LiquibaseProperties.class})
public class SpringLiquibaseConfiguration {
    private DataSource dataSource;
    private LiquibaseProperties properties;
    @Value(value="${spring.application.name}")
    private String serviceName;
    @Value(value="${service.entities.migration.enabled:false}")
    private String serviceEntitiesMigrationEnabled;

    public SpringLiquibaseConfiguration(DataSource dataSource, LiquibaseProperties properties) {
        this.dataSource = dataSource;
        this.properties = properties;
    }

    @Bean
    public SpringLiquibase liquibase() {
        SpringLiquibaseBeanAware liquibase = new SpringLiquibaseBeanAware();
        liquibase.setDataSource(this.dataSource);
        liquibase.setChangeLog(this.properties.getChangeLog());
        liquibase.setContexts(this.properties.getContexts());
        liquibase.setDefaultSchema(this.properties.getDefaultSchema());
        liquibase.setDropFirst(this.properties.isDropFirst());
        liquibase.setShouldRun(this.properties.isEnabled());
        liquibase.setLabels(this.properties.getLabels());
        HashMap<String, String> params = this.properties.getParameters();
        if (params == null) {
            params = new HashMap<String, String>();
        }
        params.put("spring.application.name", this.serviceName);
        params.put("service.entities.migration.enabled", this.serviceEntitiesMigrationEnabled);
        liquibase.setChangeLogParameters(params);
        liquibase.setRollbackFile(this.properties.getRollbackFile());
        return liquibase;
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public LiquibaseProperties getProperties() {
        return this.properties;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getServiceEntitiesMigrationEnabled() {
        return this.serviceEntitiesMigrationEnabled;
    }
}

