/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.configuration.cache;

import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.ArrayList;
import java.util.Arrays;
import org.qubership.atp.itf.lite.backend.enums.CacheKeys;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.cache.CacheManager;
import org.springframework.cache.caffeine.CaffeineCache;
import org.springframework.cache.support.SimpleCacheManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(value={"spring.cache.hazelcast.client.enable"}, havingValue="false")
public class ItfLiteNoHazelCastCacheConfiguration {
    @Bean
    public CacheManager cacheManager() {
        ArrayList caches = new ArrayList();
        Arrays.stream(CacheKeys.values()).forEach(cacheKey -> caches.add(new CaffeineCache(cacheKey.getKey(), Caffeine.newBuilder().expireAfterWrite((long)cacheKey.getTimeToLive(), cacheKey.getTimeUnit()).recordStats().maximumSize(100L).build(), true)));
        SimpleCacheManager cacheManager = new SimpleCacheManager();
        cacheManager.setCaches(caches);
        return cacheManager;
    }
}

