/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.util.UUID;
import org.qubership.atp.itf.lite.backend.feign.dto.GetAccessCodeParametersDto;
import org.qubership.atp.itf.lite.backend.service.GetAccessTokenByCodeService;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class AuthActionController {
    private final GetAccessTokenByCodeService getAccessTokenByCodeService;

    @RequestMapping(method={RequestMethod.GET}, value={"/atp-itf-lite/api/v1/authAction/saveCode/{sseId}"})
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'READ')")
    public ResponseEntity<Void> saveCode(@PathVariable(value="sseId") UUID sseId, @RequestParam(value="code") String code, @RequestParam(value="state", required=false) String state, @RequestHeader(value="X-Project-Id") UUID projectId) {
        this.getAccessTokenByCodeService.saveCode(sseId, code, state);
        return ResponseEntity.ok().build();
    }

    @RequestMapping(method={RequestMethod.POST}, value={"/atp-itf-lite/api/v1/authAction/saveParamsForGetAccessCode"}, consumes={"application/json"})
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#getAccessCodeParametersDto.getProjectId(),'EXECUTE')")
    public ResponseEntity<Void> saveParamsForGetAccessCode(GetAccessCodeParametersDto getAccessCodeParametersDto) {
        this.getAccessTokenByCodeService.saveParamsForGetAccessCode(getAccessCodeParametersDto);
        return ResponseEntity.ok().build();
    }

    public AuthActionController(GetAccessTokenByCodeService getAccessTokenByCodeService) {
        this.getAccessTokenByCodeService = getAccessTokenByCodeService;
    }
}

