/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.util.UUID;
import org.qubership.atp.itf.lite.backend.feign.service.CatalogueService;
import org.qubership.atp.itf.lite.backend.feign.service.EnvironmentFeignService;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/cache/evict"})
public class CacheEvictController {
    private final CatalogueService catalogueFeignService;
    private final EnvironmentFeignService environmentFeignService;

    @PostMapping(value={"/certificate"})
    public void evictProjectCertificateCacheByProjectId(@RequestParam UUID projectId) {
        this.catalogueFeignService.evictProjectCertificateCacheByProjectId(projectId);
    }

    @PostMapping(value={"/environment"})
    public void evictEnvironmentSystemsCacheByEnvironmentId(@RequestParam UUID environmentId) {
        this.environmentFeignService.evictEnvironmentSystemsCacheByEnvironmentId(environmentId);
    }

    public CacheEvictController(CatalogueService catalogueFeignService, EnvironmentFeignService environmentFeignService) {
        this.catalogueFeignService = catalogueFeignService;
        this.environmentFeignService = environmentFeignService;
    }
}

