/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.itf.lite.backend.facade.DocumentationFacade;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderTreeSearchRequest;
import org.qubership.atp.itf.lite.backend.model.documentation.AbstractDocumentation;
import org.qubership.atp.itf.lite.backend.model.documentation.RequestDocumentation;
import org.qubership.atp.itf.lite.backend.model.documentation.RequestEntityEditDocumentation;
import org.qubership.atp.itf.lite.backend.model.documentation.TreeFolderDocumentationResponse;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/documentation"})
public class DocumentationController {
    private final DocumentationFacade documentationFacade;

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),'READ')")
    @PostMapping(value={"/folder"})
    public ResponseEntity<TreeFolderDocumentationResponse> getFolderRequestsTree(@RequestParam int page, @RequestParam int pageSize, @RequestBody @Valid FolderTreeSearchRequest request) {
        return this.documentationFacade.getDocumentationByFolder(request, page, pageSize);
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(),'READ')")
    @GetMapping(value={"/request/{itfLiteRequestId}"})
    public ResponseEntity<RequestDocumentation> getRequest(@PathVariable(value="itfLiteRequestId") UUID requestId) {
        return this.documentationFacade.getRequestDocumentation(requestId);
    }

    @PreAuthorize(value="T(org.qubership.atp.itf.lite.backend.enums.EntityType).REQUEST.equals(#request.getType()) ? @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),@requestService.get(#id).getPermissionFolderId(),'UPDATE') and @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(), #request.getProjectId(), 'UPDATE'): @entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),@folderService.getFolder(#id).getPermissionFolderId(),'UPDATE')")
    @PatchMapping(value={"/edit/{id}"})
    public ResponseEntity<AbstractDocumentation> editDocumentation(@PathVariable(value="id") UUID id, @RequestBody @Valid RequestEntityEditDocumentation request) {
        return this.documentationFacade.editDocumentation(id, request);
    }

    public DocumentationController(DocumentationFacade documentationFacade) {
        this.documentationFacade = documentationFacade;
    }
}

