/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.itf.lite.backend.dataaccess.validators.FolderCreationRequestValidator;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderCopyRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderDeleteRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderEditRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderMoveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderOrderChangeRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderTreeSearchRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderUpsetRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.Settings;
import org.qubership.atp.itf.lite.backend.model.api.response.GroupResponse;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.service.ConcurrentModificationService;
import org.qubership.atp.itf.lite.backend.service.FolderService;
import org.springframework.data.util.Pair;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.validation.Validator;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/folders"})
public class FolderController {
    private final FolderService folderService;
    private final FolderCreationRequestValidator folderCreationRequestValidator;
    private final ConcurrentModificationService concurrentModificationService;

    @InitBinder
    public void dataBindings(WebDataBinder binder) {
        Object target = binder.getTarget();
        if (target != null && FolderUpsetRequest.class.equals(target.getClass())) {
            binder.addValidators(new Validator[]{this.folderCreationRequestValidator});
        }
    }

    @AuditAction(auditAction="Get all folders. Filters: project id = {{#projectId}}")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#projectId,'READ')")
    @GetMapping
    public ResponseEntity<Collection<Folder>> getAllFolders(@RequestParam(required=false) UUID projectId) {
        return ResponseEntity.ok(this.folderService.getAllFolders(projectId));
    }

    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),@folderService.getFolder(#folderId).getProjectId(), 'READ')")
    @GetMapping(value={"/{id}/settings"})
    public ResponseEntity<Settings> getFolderSettings(@PathVariable(value="id") UUID folderId) {
        return ResponseEntity.ok((Object)this.folderService.getSettings(folderId));
    }

    @AuditAction(auditAction="Create folder with name '{{#request.name}}' in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),#request.getParentId() != null ? @folderService.getFolder(#request.getParentId()).getPermissionFolderId() : null,'CREATE')")
    @PostMapping
    public ResponseEntity<Folder> createFolder(@RequestBody @Valid FolderUpsetRequest request) throws Exception {
        return new ResponseEntity((Object)this.folderService.createFolder(request), HttpStatus.CREATED);
    }

    @AuditAction(auditAction="Edit folder with name '{{#request.name}}' in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(), @folderService.getFolder(#folderId).getPermissionFolderId(), 'UPDATE')")
    @PutMapping(value={"/{id}"})
    public ResponseEntity<Void> editFolder(@PathVariable(value="id") UUID folderId, @RequestBody FolderEditRequest request) throws Exception {
        HttpStatus status = this.concurrentModificationService.getConcurrentModificationHttpStatus(folderId, request.getModifiedWhen(), this.folderService);
        this.folderService.editFolder(folderId, request);
        return ResponseEntity.status((HttpStatus)status).build();
    }

    @AuditAction(auditAction="Copy folders with ids [{#request.ids}}] in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),#request.getToFolderId() != null ? @folderService.getFolder(#request.getToFolderId()).getPermissionFolderId() : null,'CREATE')")
    @PostMapping(value={"/copy"})
    public ResponseEntity<Void> copyFolders(@RequestBody @Valid FolderCopyRequest request) {
        this.folderService.copyFolders(request);
        return ResponseEntity.ok().build();
    }

    @AuditAction(auditAction="Move folders with ids [{#request.ids}}] to folder '{{#request.toFolderId}}' in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),#request.getToFolderId() != null ? @folderService.getFolder(#request.getToFolderId()).getPermissionFolderId() : null,'CREATE')")
    @PostMapping(value={"/move"})
    public ResponseEntity<List<UUID>> moveFolders(@RequestBody @Valid FolderMoveRequest request) {
        Pair<HttpStatus, List<UUID>> concurrentModificationRes = this.concurrentModificationService.getConcurrentModificationHttpStatus(request.getIds(), this.folderService);
        this.folderService.moveFolders(request);
        return ResponseEntity.status((HttpStatus)((HttpStatus)concurrentModificationRes.getFirst())).body((Object)((List)concurrentModificationRes.getSecond()));
    }

    @AuditAction(auditAction="Delete folders with ids [{#request.ids}}] in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),@folderService.getPermissionFolderIdsByFolderIds(#request.getIds()),'DELETE')")
    @DeleteMapping
    public ResponseEntity<Void> deleteFolders(@RequestBody @Valid FolderDeleteRequest request) {
        this.folderService.deleteFolders(request);
        return ResponseEntity.ok().build();
    }

    @AuditAction(auditAction="Count heirs for folders with ids [{#request.ids}}] in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),'READ')")
    @PostMapping(value={"/countHeirs"})
    public ResponseEntity<Long> countFolderHeirs(@RequestBody @Valid FolderDeleteRequest request) {
        return ResponseEntity.ok((Object)this.folderService.countFolderHeirs(request));
    }

    @AuditAction(auditAction="Get folder requests tree for the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),'READ')")
    @PostMapping(value={"/tree"})
    public ResponseEntity<GroupResponse> getFolderRequestsTree(@RequestParam(required=false, defaultValue="false") Boolean onlyFolders, @RequestBody @Valid FolderTreeSearchRequest request) {
        return ResponseEntity.ok((Object)this.folderService.getFolderRequestsTree(onlyFolders, request));
    }

    @AuditAction(auditAction="Change order for the folder '{{#folderId}}' in the '{{#request.projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).FOLDER.getName(),#request.getProjectId(),@folderService.getFolder(#folderId).getPermissionFolderId(),'UPDATE')")
    @PostMapping(value={"/{id}/order"})
    public ResponseEntity<Void> order(@PathVariable(value="id") UUID folderId, @RequestBody FolderOrderChangeRequest request) {
        this.folderService.order(folderId, request);
        return ResponseEntity.ok().build();
    }

    public FolderController(FolderService folderService, FolderCreationRequestValidator folderCreationRequestValidator, ConcurrentModificationService concurrentModificationService) {
        this.folderService = folderService;
        this.folderCreationRequestValidator = folderCreationRequestValidator;
        this.concurrentModificationService = concurrentModificationService;
    }
}

