/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.util.UUID;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.integration.configuration.mdc.MdcUtils;
import org.qubership.atp.itf.lite.backend.mdc.ItfLiteMdcField;
import org.qubership.atp.itf.lite.backend.service.RequestHeaderService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/request-headers"})
public class RequestHeadersController {
    private static final Logger log = LoggerFactory.getLogger(RequestHeadersController.class);
    private final RequestHeaderService service;

    @AuditAction(auditAction="Disable request '{{#requestId}}' header '{{#headerId}}' in '{{#projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId,@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE')")
    @PutMapping(value={"/{id}/disable"})
    public void disableRequestHeader(@RequestParam UUID projectId, @RequestParam UUID requestId, @PathVariable(value="id") UUID headerId) {
        MdcUtils.put((String)ItfLiteMdcField.REQUEST_ID.toString(), (UUID)requestId);
        log.info("Request to disable header with id '{}' for request with id '{}'", (Object)headerId, (Object)requestId);
        this.service.disableRequestHeader(headerId);
    }

    @AuditAction(auditAction="Enable request '{{#requestId}}' header '{{#headerId}}' in '{{#projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#projectId,@requestService.getRequest(#requestId).getPermissionFolderId(),'UPDATE')")
    @PutMapping(value={"/{id}/enable"})
    public void enableRequestHeader(@RequestParam UUID projectId, @RequestParam UUID requestId, @PathVariable(value="id") UUID headerId) {
        MdcUtils.put((String)ItfLiteMdcField.REQUEST_ID.toString(), (UUID)requestId);
        log.info("Request to enable header with id '{}' for request with id '{}'", (Object)headerId, (Object)requestId);
        this.service.enableRequestHeader(headerId);
    }

    public RequestHeadersController(RequestHeaderService service) {
        this.service = service;
    }
}

