/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.controllers;

import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.validation.Valid;
import org.qubership.atp.integration.configuration.configuration.AuditAction;
import org.qubership.atp.itf.lite.backend.enums.ImportToolType;
import org.qubership.atp.itf.lite.backend.model.RequestRuntimeOptions;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestItfExportRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestMiaExportRequest;
import org.qubership.atp.itf.lite.backend.service.RequestExportService;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.service.SseEmitterService;
import org.qubership.atp.itf.lite.backend.service.UserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@RestController
@RequestMapping(value={"/atp-itf-lite/api/v1/sse"})
public class SseController {
    private static final Logger log = LoggerFactory.getLogger(SseController.class);
    private final RequestService requestService;
    private final RequestExportService requestExportService;
    private final SseEmitterService sseEmitterService;
    private final UserService userService;

    @AuditAction(auditAction="Connect to SSE emitter with id '{{#sseId}}' for the '{{#projectId}}' project")
    @PreAuthorize(value="@entityAccess.checkAccess(#projectId,'READ')")
    @GetMapping(value={"/requests/connect"}, produces={"text/event-stream"})
    public SseEmitter connect(@RequestParam UUID projectId, @RequestParam UUID sseId, @RequestHeader(value="Authorization") String token) throws IOException {
        SseEmitter emitter = this.sseEmitterService.getEmitter(sseId);
        if (emitter != null) {
            log.debug("Emitter already exists. Return existing emitter.");
            return emitter;
        }
        UUID userId = this.userService.getUserIdFromToken(token);
        return this.sseEmitterService.generateAndConfigureEmitter(sseId, userId);
    }

    @AuditAction(auditAction="Execute request with id '{{#requestId}}'")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),@requestService.getRequest(#requestId).getProjectId(),'EXECUTE')")
    @PostMapping(value={"/requests/{itfLiteRequestId}/execute"})
    public void executeRequest(@PathVariable(value="itfLiteRequestId") UUID requestId, @RequestHeader(value="Authorization") String token, @RequestParam(required=false) UUID environmentId, @RequestParam(required=false) String context, @RequestParam(required=false) UUID sessionId, @RequestParam UUID sseId, @RequestPart(name="file", required=false) MultipartFile dictionary, @RequestPart(name="files", required=false) List<MultipartFile> files, @RequestPart(name="requestEntity") @Valid RequestEntitySaveRequest requestEntity) {
        log.debug("Check if request with requestId {} exists", (Object)requestId);
        RequestRuntimeOptions runtimeOptions = this.requestService.retrieveRuntimeOptions(requestId);
        requestEntity.setId(requestId);
        this.sseEmitterService.processRequestExecution(requestEntity, context, token, sseId, Optional.ofNullable(dictionary), files, environmentId, runtimeOptions, sessionId);
    }

    @AuditAction(auditAction="Export requests [{{#miaExportRequest.requestIds}}] to MIA")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#miaExportRequest.getProjectId(),@requestService.getPermissionFolderIdsByRequestIds(#miaExportRequest.getRequestIds()),'READ')")
    @PostMapping(value={"/requests/mia/export"})
    public void exportRequestsToMia(@RequestParam UUID sseId, @RequestParam(required=false) UUID environmentId, @RequestParam(required=false) String context, @RequestBody @Valid RequestMiaExportRequest miaExportRequest, @RequestHeader(value="Authorization") String token) {
        UUID userId = this.userService.getUserIdFromToken(token);
        this.requestExportService.exportRequests(sseId, userId, miaExportRequest, ImportToolType.MIA, context, environmentId);
    }

    @AuditAction(auditAction="Export requests [{{#itfExportRequest.requestIds}}] to ITF")
    @PreAuthorize(value="@entityAccess.checkAccess(T(org.qubership.atp.itf.lite.backend.utils.UserManagementEntities).REQUEST.getName(),#itfExportRequest.getProjectId(),@requestService.getPermissionFolderIdsByRequestIds(#itfExportRequest.getRequestIds()),'READ')")
    @PostMapping(value={"/requests/itf/export"})
    public void exportRequestsToItf(@RequestParam UUID sseId, @RequestParam(required=false) UUID environmentId, @RequestBody @Valid RequestItfExportRequest itfExportRequest, @RequestHeader(value="Authorization") String token) {
        UUID userId = this.userService.getUserIdFromToken(token);
        this.requestExportService.exportRequests(sseId, userId, itfExportRequest, ImportToolType.ITF, null, environmentId);
    }

    public SseController(RequestService requestService, RequestExportService requestExportService, SseEmitterService sseEmitterService, UserService userService) {
        this.requestService = requestService;
        this.requestExportService = requestExportService;
        this.sseEmitterService = sseEmitterService;
        this.userService = userService;
    }
}

