/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.converters;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.openjdk.nashorn.tools.Shell;
import org.qubership.atp.itf.lite.backend.converters.curl.CurlOptions;
import org.qubership.atp.itf.lite.backend.converters.curl.CurlUtils;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.enums.ValueType;
import org.qubership.atp.itf.lite.backend.enums.http.RequestBodyType;
import org.qubership.atp.itf.lite.backend.exceptions.converters.BadFormDataFormatException;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.http.FormDataPart;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;
import org.qubership.atp.itf.lite.backend.utils.UrlParsingUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CurlFormatToRequestConverter
implements CurlOptions {
    private static final Logger log = LoggerFactory.getLogger(CurlFormatToRequestConverter.class);
    private static final String lineSeparatorPattern = "\\\\?(\\r\\n|\\r|\\n)";
    private static final String KEY_GROUP_NAME = "key";
    private static final String VALUE_GROUP_NAME = "value";
    private static final String IS_FILE_GROUP_NAME = "isFile";
    private static final String CONTENT_TYPE_GROUP_NAME = "contentType";
    private static final Pattern formDataMatcher = Pattern.compile("^(?<key>[^;]*)=(?<isFile>@)?(?<value>[^;]*)((;type=(?<contentType>[^;]*))|(;filename=[^;]*)){0,2}$");

    public HttpRequest convertCurlStringToRequest(HttpRequest httpRequest, String curlString) {
        curlString = curlString.replaceAll(lineSeparatorPattern, "<tls>");
        List tokens = Shell.tokenizeString((String)curlString);
        this.clearRequest(httpRequest);
        block7: for (int i = 0; i < tokens.size(); ++i) {
            String token = (String)tokens.get(i);
            if (token.startsWith("<tls>")) {
                token = token.replaceAll("<tls>", "");
            }
            if (token.startsWith("http://") || token.startsWith("https://")) {
                UrlParsingUtils.parseUrlAndRequestParams(httpRequest, token);
            }
            switch (optionsMap.getOrDefault(token, -1)) {
                case 1: {
                    this.parseBody(httpRequest, i, tokens);
                    continue block7;
                }
                case 2: {
                    this.parseHeaders(httpRequest, i, tokens);
                    continue block7;
                }
                case 3: {
                    this.parseHttpMethod(httpRequest, i, tokens);
                    continue block7;
                }
                case 4: {
                    this.parseFormData(httpRequest, i, tokens);
                    continue block7;
                }
                case 5: {
                    log.warn("Import request with binary body not allowed");
                    continue block7;
                }
                default: {
                    log.debug("Unknown curl parameter - {}", (Object)token);
                }
            }
        }
        if (this.hasXmlHeader(httpRequest.getRequestHeaders())) {
            httpRequest.getBody().setType(RequestBodyType.XML);
        }
        this.setDefaultValuesIfNull(httpRequest);
        return httpRequest;
    }

    private void clearRequest(HttpRequest httpRequest) {
        httpRequest.setUrl("");
        httpRequest.setRequestHeaders(new ArrayList<RequestHeader>());
        httpRequest.setHttpMethod(HttpMethod.GET);
        httpRequest.setBody(null);
        httpRequest.setRequestParams(null);
    }

    private boolean hasXmlHeader(List<RequestHeader> headers) {
        return headers.stream().anyMatch(CurlUtils::isHeaderXmlContentType);
    }

    private void setDefaultValuesIfNull(HttpRequest httpRequest) {
        if (httpRequest.getHttpMethod() == null) {
            httpRequest.setHttpMethod(HttpMethod.GET);
        }
        httpRequest.setTransportType(TransportType.REST);
    }

    private boolean isNextTokenValue(int currentOptionNumber, List<String> tokens) {
        return currentOptionNumber + 1 < tokens.size() && !tokens.get(currentOptionNumber + 1).startsWith("-");
    }

    private void parseBody(HttpRequest httpRequest, int currentTokenNumber, List<String> tokens) {
        if (this.isNextTokenValue(currentTokenNumber, tokens)) {
            RequestBody body = new RequestBody();
            String content = tokens.get(currentTokenNumber + 1).replaceAll("<tls>", System.lineSeparator());
            body.setContent(content);
            if (!body.detectAndFillGraphQlProperties(content)) {
                body.setType(RequestBodyType.JSON);
            }
            httpRequest.setBody(body);
        }
    }

    private void parseFormData(HttpRequest httpRequest, int currentTokenNumber, List<String> tokens) {
        if (this.isNextTokenValue(currentTokenNumber, tokens)) {
            String content = tokens.get(currentTokenNumber + 1).replaceAll("<tls>", System.lineSeparator());
            log.debug("Parse form data part {}", (Object)content);
            Matcher matcher = formDataMatcher.matcher(content);
            if (!matcher.matches()) {
                log.error("Bad form data format - {}", (Object)content);
                throw new BadFormDataFormatException(content);
            }
            RequestBody body = httpRequest.getBody();
            if (body == null) {
                body = new RequestBody();
                body.setType(RequestBodyType.FORM_DATA);
            }
            List<FormDataPart> formDataParts = body.getFormDataBody();
            if (body.getFormDataBody() == null) {
                formDataParts = new ArrayList<FormDataPart>();
            }
            String key = matcher.group(KEY_GROUP_NAME);
            String value = matcher.group(VALUE_GROUP_NAME);
            String isFile = matcher.group(IS_FILE_GROUP_NAME);
            String contentType = matcher.group(CONTENT_TYPE_GROUP_NAME);
            if (StringUtils.isNotEmpty((String)isFile)) {
                log.warn("Importing file in form data not allowed");
                return;
            }
            formDataParts.add(new FormDataPart(key, ValueType.TEXT, value, null, contentType, "", false));
            body.setFormDataBody(formDataParts);
            httpRequest.setBody(body);
        }
    }

    private void parseHeaders(HttpRequest httpRequest, int currentTokenNumber, List<String> tokens) {
        if (this.isNextTokenValue(currentTokenNumber, tokens)) {
            String[] header = tokens.get(currentTokenNumber + 1).split(":", 2);
            String name = StringUtils.strip((String)header[0].trim(), (String)";");
            if (header.length == 1) {
                RequestHeader requestHeader = new RequestHeader();
                requestHeader.setKey(name);
                requestHeader.setValue("");
                requestHeader.setDescription("");
                httpRequest.getRequestHeaders().add(requestHeader);
            } else {
                String value = header[1].trim();
                RequestHeader requestHeader = new RequestHeader();
                requestHeader.setKey(name);
                requestHeader.setValue(value);
                requestHeader.setDescription("");
                httpRequest.getRequestHeaders().add(requestHeader);
            }
        }
    }

    private void parseHttpMethod(HttpRequest httpRequest, int currentTokenNumber, List<String> tokens) {
        if (this.isNextTokenValue(currentTokenNumber, tokens)) {
            httpRequest.setHttpMethod(HttpMethod.valueOf(tokens.get(currentTokenNumber + 1)));
        }
    }
}

