/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.converters.history;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.converters.history.AbstractVersioningMapper;
import org.qubership.atp.itf.lite.backend.feign.dto.history.AuthorizationDto;
import org.qubership.atp.itf.lite.backend.feign.dto.history.FolderHistoryChangeDto;
import org.qubership.atp.itf.lite.backend.feign.dto.history.HistoryItemTypeDto;
import org.qubership.atp.itf.lite.backend.feign.dto.history.PermissionDto;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.PermissionEntity;
import org.qubership.atp.itf.lite.backend.model.entities.converters.ListConverter;
import org.qubership.atp.itf.lite.backend.model.entities.converters.PermissionEntityConverter;
import org.springframework.stereotype.Component;

@Component
public class FolderVersioningMapper
extends AbstractVersioningMapper<Folder, FolderHistoryChangeDto> {
    private final PermissionEntityConverter permissionEntityConverter;
    private final ListConverter listConverter;

    FolderVersioningMapper(PermissionEntityConverter permissionEntityConverter, ListConverter listConverter, ModelMapper mapper) {
        super(Folder.class, FolderHistoryChangeDto.class, mapper);
        this.permissionEntityConverter = permissionEntityConverter;
        this.listConverter = listConverter;
    }

    @Override
    HistoryItemTypeDto getEntityTypeEnum() {
        return HistoryItemTypeDto.FOLDER;
    }

    @Override
    void mapSpecificFields(Folder source, FolderHistoryChangeDto destination) {
        super.mapSpecificFields(source, destination);
        destination.isAutoCookieDisabled(source.isAutoCookieDisabled());
        destination.setDisableFollowingRedirect(source.isDisableFollowingRedirect());
        destination.setDisableSslClientCertificate(source.isDisableSslClientCertificate());
        destination.setDisableSslCertificateVerification(source.isDisableSslCertificateVerification());
        destination.setChildFolders(this.listConverter.convertToEntityAttribute(source.getChildFolders()));
        destination.requests(this.listConverter.convertToEntityAttribute(source.getChildRequests()));
        PermissionEntity permissionEntity = this.permissionEntityConverter.convertToEntityAttribute(source.getPermission());
        if (permissionEntity != null) {
            destination.setPermission(new PermissionDto().isEnable(permissionEntity.isEnable()).userAccess((List<String>)(permissionEntity.getUserAccess() == null ? null : new ArrayList<String>(permissionEntity.getUserAccess().values()))));
        }
        if (Objects.nonNull(source.getAuthorization())) {
            destination.setAuthorization((AuthorizationDto)this.mapper.map((Object)source.getAuthorization(), AuthorizationDto.class));
        }
    }
}

