/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.dataaccess.migration;

import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import liquibase.change.custom.CustomTaskChange;
import liquibase.database.Database;
import liquibase.exception.SetupException;
import liquibase.exception.ValidationErrors;
import liquibase.resource.ResourceAccessor;
import org.qubership.atp.itf.lite.backend.configuration.SpringLiquibaseBeanAware;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.FolderRepository;
import org.qubership.atp.itf.lite.backend.dataaccess.repository.RequestRepository;
import org.qubership.atp.itf.lite.backend.enums.EntityType;
import org.qubership.atp.itf.lite.backend.model.api.response.GroupResponse;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class FolderRequestsOrderMigrationTask
implements CustomTaskChange {
    private static final Logger log = LoggerFactory.getLogger(FolderRequestsOrderMigrationTask.class);

    public void execute(Database database) {
        log.debug("Trying to execute migration script for setting requests and folders order");
        try {
            FolderRepository folderRepository = SpringLiquibaseBeanAware.getBean(FolderRepository.class);
            RequestRepository requestRepository = SpringLiquibaseBeanAware.getBean(RequestRepository.class);
            List allFolders = folderRepository.findAll();
            List allRequests = requestRepository.findAll();
            Map<UUID, List<Folder>> foldersToProjectMap = StreamUtils.toEntityListMap(allFolders, Folder::getProjectId);
            Map<UUID, List<Request>> requestsToProjectMap = StreamUtils.toEntityListMap(allRequests, Request::getProjectId);
            Set<UUID> projectIds = foldersToProjectMap.keySet();
            for (UUID projectId : projectIds) {
                GroupResponse root = new GroupResponse();
                List<Folder> projectFolders = foldersToProjectMap.get(projectId);
                List<Request> projectRequests = requestsToProjectMap.get(projectId);
                GroupResponse tree = this.buildTree(root, projectFolders, projectRequests);
                this.setOrder(tree, StreamUtils.toIdEntityMap(projectFolders), StreamUtils.toIdEntityMap(projectRequests));
                folderRepository.saveAll(allFolders);
                requestRepository.saveAll(projectRequests);
            }
        }
        catch (Exception err) {
            log.error("Failed to complete migration script for setting requests and folders order", (Throwable)err);
        }
        log.debug("Migration script have been successfully executed");
    }

    private void setOrder(GroupResponse root, Map<UUID, Folder> folderMap, Map<UUID, Request> requestMap) {
        List<GroupResponse> children = root.getChildren();
        if (!CollectionUtils.isEmpty(children)) {
            int order = 0;
            for (GroupResponse child : children) {
                EntityType type = child.getType();
                UUID id = child.getId();
                if (type.equals((Object)EntityType.FOLDER)) {
                    this.setOrder(child, folderMap, requestMap);
                    Folder folder = folderMap.get(id);
                    folder.setOrder(order++);
                    continue;
                }
                Request request = requestMap.get(id);
                request.setOrder(order++);
            }
        }
    }

    private GroupResponse buildTree(GroupResponse root, List<Folder> allFolders, List<Request> allRequests) {
        List<Request> requests;
        List<Folder> folders;
        EntityType type = root.getType();
        UUID parentId = root.getId();
        List<GroupResponse> children = root.getChildren();
        if (Objects.isNull((Object)type)) {
            folders = StreamUtils.filterList(allFolders, folder -> Objects.isNull(folder.getParentId()));
            requests = StreamUtils.filterList(allRequests, request -> Objects.isNull(request.getFolderId()));
        } else {
            folders = StreamUtils.filterList(allFolders, folder -> parentId.equals(folder.getParentId()));
            requests = StreamUtils.filterList(allRequests, request -> parentId.equals(request.getFolderId()));
        }
        if (!CollectionUtils.isEmpty(requests)) {
            children.addAll(StreamUtils.map(requests, request -> new GroupResponse((Request)request, null)));
        }
        if (!CollectionUtils.isEmpty(folders)) {
            children.addAll(StreamUtils.map(folders, folder -> this.buildTree(new GroupResponse((Folder)folder, null), allFolders, allRequests)));
        }
        children.sort((first, second) -> {
            Date firstCreatedWhen = first.getCreatedWhen();
            Date secondCreatedWhen = second.getCreatedWhen();
            if (Objects.nonNull(firstCreatedWhen) && Objects.nonNull(secondCreatedWhen)) {
                return firstCreatedWhen.compareTo(secondCreatedWhen);
            }
            return 0;
        });
        return root;
    }

    public String getConfirmationMessage() {
        return null;
    }

    public void setUp() throws SetupException {
    }

    public void setFileOpener(ResourceAccessor resourceAccessor) {
    }

    public ValidationErrors validate(Database database) {
        return null;
    }
}

