/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.dataaccess.repository.history;

import java.util.Collection;
import java.util.List;
import org.javers.core.metamodel.object.SnapshotType;
import org.qubership.atp.itf.lite.backend.model.api.response.history.JaversCountResponse;
import org.qubership.atp.itf.lite.backend.model.entities.javers.history.JvSnapshotEntity;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;

@Repository
public interface JaversSnapshotRepository
extends JpaRepository<JvSnapshotEntity, Long> {
    public Page<JvSnapshotEntity> findAllByTypeIs(SnapshotType var1, Pageable var2);

    public List<JvSnapshotEntity> findAllByGlobalIdIn(Collection<Long> var1);

    public List<JvSnapshotEntity> findAllByGlobalIdOrderByVersionAsc(Long var1, Pageable var2);

    public JvSnapshotEntity findFirstByGlobalIdOrderByVersionAsc(Long var1);

    public Long countByCommitId(Long var1);

    @Modifying
    public void deleteByVersionAndGlobalIdAndCommitId(Long var1, Long var2, Long var3);

    @Modifying
    @Query(value="DELETE FROM JvSnapshotEntity e WHERE e.globalId IN (:globalIds)")
    public void deleteByGlobalIdIn(@Param(value="globalIds") Collection<Long> var1);

    @Modifying
    @Query(value="DELETE FROM JvSnapshotEntity e WHERE e.commitId IN (:commitIds)")
    public void deleteByCommitIdIn(@Param(value="commitIds") Collection<Long> var1);

    @Query(value="SELECT e.globalId AS id, COUNT(e.globalId) AS count FROM JvSnapshotEntity e GROUP BY e.globalId HAVING COUNT(e.globalId) > :count")
    public List<JaversCountResponse> findGlobalIdAndCountGreaterThan(@Param(value="count") long var1);
}

