/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.ei.service;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.exceptions.folders.ItfLiteImportFolderFileLoadException;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractEntity;
import org.qubership.atp.itf.lite.backend.model.entities.Folder;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BasicRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BearerRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.InheritFromParentRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.OAuth2RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.service.FolderService;
import org.qubership.atp.itf.lite.backend.utils.JsonObject;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class FolderImporterService {
    private static final Logger log = LoggerFactory.getLogger(FolderImporterService.class);
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private final FolderService folderService;
    private final ModelMapper modelMapper;

    public void importFolders(Path workDir, ExportImportData importData) {
        Map folderFiles = this.objectLoaderFromDiskService.getListOfObjects(workDir, Folder.class);
        Map replacementMap = importData.getReplacementMap();
        log.debug("importFolders list: {}", (Object)folderFiles);
        boolean isReplacement = importData.isInterProjectImport() || importData.isCreateNewProject();
        ArrayList parsedFolders = new ArrayList();
        folderFiles.forEach((folderId, filePath) -> {
            log.debug("importFolders starts import: {}.", folderId);
            Folder folderObject = this.load((Path)filePath, replacementMap, isReplacement, new JSONParser());
            log.debug("Imports folder:{}", (Object)folderObject);
            if (folderObject == null) {
                String path = filePath.toString();
                log.error("Failed to upload file using path: {}", filePath);
                throw new ItfLiteImportFolderFileLoadException(path);
            }
            folderObject.setSourceId((UUID)folderId);
            parsedFolders.add(folderObject);
        });
        Map<UUID, List<Folder>> foldersGroupedByParentFolders = parsedFolders.stream().filter(folder -> Objects.nonNull(folder.getParentId())).collect(Collectors.groupingBy(Folder::getParentId));
        for (Map.Entry<UUID, List<Folder>> foldersByParentId : foldersGroupedByParentFolders.entrySet()) {
            UUID projectId = foldersByParentId.getValue().get(0).getProjectId();
            List<Folder> destinationFolders = this.folderService.getAllByProjectIdAndParentId(projectId, foldersByParentId.getKey());
            foldersByParentId.getValue().forEach(folderObject -> {
                List<Folder> foldersWithoutCurrentFolder = ((List)foldersByParentId.getValue()).stream().filter(folder -> !folder.equals(folderObject)).collect(Collectors.toList());
                foldersWithoutCurrentFolder.addAll(destinationFolders);
                foldersWithoutCurrentFolder = foldersWithoutCurrentFolder.stream().filter(StreamUtils.distinctByKey(AbstractEntity::getId)).collect(Collectors.toList());
                this.folderService.addPostfixIfFolderNameInDestinationIsTaken(foldersWithoutCurrentFolder, (Folder)folderObject);
            });
        }
        List<Folder> rootFolderFolderObjects = parsedFolders.stream().filter(folder -> Objects.isNull(folder.getParentId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(rootFolderFolderObjects)) {
            UUID projectId = ((Folder)rootFolderFolderObjects.get(0)).getProjectId();
            List<Folder> rootFolderFolders = this.folderService.getAllByProjectIdAndParentId(projectId, null);
            rootFolderFolderObjects.forEach(folderObject -> {
                List<Folder> foldersWithoutCurrentFolder = rootFolderFolderObjects.stream().filter(folder -> !folder.equals(folderObject)).collect(Collectors.toList());
                foldersWithoutCurrentFolder.addAll(rootFolderFolders);
                foldersWithoutCurrentFolder = foldersWithoutCurrentFolder.stream().filter(StreamUtils.distinctByKey(AbstractEntity::getId)).collect(Collectors.toList());
                this.folderService.addPostfixIfFolderNameInDestinationIsTaken(foldersWithoutCurrentFolder, (Folder)folderObject);
            });
        }
        rootFolderFolderObjects.addAll(foldersGroupedByParentFolders.entrySet().stream().flatMap(uuidListEntry -> ((List)uuidListEntry.getValue()).stream()).collect(Collectors.toList()));
        this.folderService.saveAll(rootFolderFolderObjects);
    }

    private Folder load(Path filePath, Map<UUID, UUID> replacementMap, boolean isReplacement, JSONParser jsonParser) {
        Folder folder;
        if (isReplacement) {
            log.debug("Load folder by path [{}] with replacementMap: {}", (Object)filePath, replacementMap);
            folder = (Folder)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(filePath, Folder.class, replacementMap, true, false);
        } else {
            log.debug("Load folder by path [{}] without replacementMap", (Object)filePath);
            folder = (Folder)this.objectLoaderFromDiskService.loadFileAsObject(filePath, Folder.class);
        }
        if (Objects.nonNull(folder)) {
            log.debug("RequestAuthorization parsing for folder = {}", (Object)folder.getId());
            folder.setAuthorization(this.parseRequestAuthorizationFolder(filePath, replacementMap, isReplacement, folder.getAuthorization(), jsonParser));
            return folder;
        }
        return null;
    }

    private RequestAuthorization parseRequestAuthorizationFolder(Path filePath, Map<UUID, UUID> replacementMap, boolean isReplacement, RequestAuthorization requestAuthorization, JSONParser parser) {
        if (Objects.nonNull(requestAuthorization)) {
            RequestAuthorizationType authType = requestAuthorization.getType();
            switch (authType) {
                case OAUTH2: {
                    return this.prepareRequestAuthFolder(filePath, replacementMap, isReplacement, parser, OAuth2RequestAuthorization.class);
                }
                case BASIC: {
                    return this.prepareRequestAuthFolder(filePath, replacementMap, isReplacement, parser, BasicRequestAuthorization.class);
                }
                case BEARER: {
                    return this.prepareRequestAuthFolder(filePath, replacementMap, isReplacement, parser, BearerRequestAuthorization.class);
                }
                case INHERIT_FROM_PARENT: {
                    return this.prepareRequestAuthFolder(filePath, replacementMap, isReplacement, parser, InheritFromParentRequestAuthorization.class);
                }
            }
            log.warn("Request with type {} will not be parsing", (Object)authType);
        }
        log.debug("Request authorization not found in {}", (Object)filePath);
        return requestAuthorization;
    }

    private <T extends RequestAuthorization> T prepareRequestAuthFolder(Path filePath, Map<UUID, UUID> replacementMap, boolean isReplacement, JSONParser parser, Class<T> neededClass) {
        try {
            log.debug("Read request from {}", (Object)filePath);
            String requestString = IOUtils.toString((InputStream)Files.newInputStream(filePath, new OpenOption[0]));
            JsonObject parsedFolderRequest = new JsonObject(parser.parse(requestString));
            JsonObject authorizationJsonFolder = parsedFolderRequest.getObject("authorization");
            if (authorizationJsonFolder == null) {
                log.warn("Authorization field is missing or null in the parsed request from file {}", (Object)filePath);
                return null;
            }
            log.debug("Map parsed request authorization into OAuth2RequestAuthorization");
            RequestAuthorization parsedRequestAuthorization = (RequestAuthorization)this.modelMapper.map((Object)authorizationJsonFolder.getObj(), neededClass);
            UUID parsedRequestAuthorizationId = parsedRequestAuthorization.getId();
            if (isReplacement && replacementMap.containsKey(parsedRequestAuthorizationId)) {
                log.debug("Replace request authorization id");
                parsedRequestAuthorization.setId(replacementMap.get(parsedRequestAuthorizationId));
            }
            return (T)parsedRequestAuthorization;
        }
        catch (IOException | ParseException e) {
            log.error("Can't get authorization from file {}.", (Object)filePath, (Object)e);
            return null;
        }
    }

    public Map<UUID, UUID> getSourceTargetMap(Path workDir, Map<UUID, UUID> replacementMap) {
        log.debug("Get source target replacement map");
        HashMap<UUID, UUID> result = new HashMap<UUID, UUID>();
        Map objectsToImport = this.objectLoaderFromDiskService.getListOfObjects(workDir, Folder.class);
        objectsToImport.forEach((uuid, filePath) -> {
            Folder object = (Folder)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(filePath, Folder.class, replacementMap);
            Folder existingObject = this.folderService.getByProjectIdAndSourceId(object.getProjectId(), (UUID)uuid);
            if (existingObject == null) {
                log.debug("Folder by projectId: [{}] and sourceId: [{}] not found", (Object)object.getProjectId(), uuid);
                log.debug("Put {}: null to replacementMap", uuid);
                result.put((UUID)uuid, (UUID)null);
            } else {
                log.debug("Folder by projectId: [{}] and sourceId: [{}] found", (Object)object.getProjectId(), uuid);
                log.debug("Put {}: {} to replacementMap", uuid, (Object)existingObject.getId());
                result.put((UUID)uuid, existingObject.getId());
            }
        });
        return result;
    }

    public FolderImporterService(ObjectLoaderFromDiskService objectLoaderFromDiskService, FolderService folderService, ModelMapper modelMapper) {
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
        this.folderService = folderService;
        this.modelMapper = modelMapper;
    }
}

