/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.ei.service;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.IOUtils;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.modelmapper.ModelMapper;
import org.qubership.atp.ei.node.dto.ExportImportData;
import org.qubership.atp.ei.node.services.ObjectLoaderFromDiskService;
import org.qubership.atp.itf.lite.backend.enums.auth.RequestAuthorizationType;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteImportRequestFileLoadException;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractEntity;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BasicRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.BearerRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.InheritFromParentRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.OAuth2RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileInfo;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.qubership.atp.itf.lite.backend.utils.JsonObject;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RequestImporterService {
    private static final Logger log = LoggerFactory.getLogger(RequestImporterService.class);
    private static final String DESCRIPTOR_FILE_NAME_REGEXP = "[0-9a-f]{8}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{4}-[0-9a-f]{12}\\.json";
    private final ObjectLoaderFromDiskService objectLoaderFromDiskService;
    private final RequestService requestService;
    private final ModelMapper modelMapper;
    private final GridFsService gridFsService;

    public void importRequests(Path workDir, ExportImportData importData) {
        Map<UUID, Path> requestFiles = this.getListOfRequests(workDir);
        Map replacementMap = importData.getReplacementMap();
        log.debug("importRequests list: {}", requestFiles);
        JSONParser parser = new JSONParser();
        boolean isReplacement = importData.isInterProjectImport() || importData.isCreateNewProject();
        ArrayList parsedRequests = new ArrayList();
        requestFiles.forEach((requestId, filePath) -> {
            log.debug("importRequest starts import: {}.", requestId);
            Request requestObject = this.loadRequest((Path)filePath, replacementMap, isReplacement, parser);
            log.debug("Imports request:{}", (Object)requestObject);
            if (requestObject == null) {
                String path = filePath.toString();
                log.error("Failed to upload file using path: {}", filePath);
                throw new ItfLiteImportRequestFileLoadException(path);
            }
            requestObject.setSourceId((UUID)requestId);
            parsedRequests.add(requestObject);
        });
        Map<UUID, List<Request>> requestsGroupedByFolders = parsedRequests.stream().filter(request -> Objects.nonNull(request.getFolderId())).collect(Collectors.groupingBy(Request::getFolderId));
        for (Map.Entry<UUID, List<Request>> requestsByFolder : requestsGroupedByFolders.entrySet()) {
            UUID projectId = requestsByFolder.getValue().get(0).getProjectId();
            List<Request> folderRequests = this.requestService.getAllRequestsByProjectIdFolderIdsRequestIds(projectId, Sets.newHashSet((Object[])new UUID[]{requestsByFolder.getKey()}), null);
            requestsByFolder.getValue().forEach(requestObject -> {
                List<Request> requestsWithoutCurrentRequest = ((List)requestsByFolder.getValue()).stream().filter(request -> !request.equals(requestObject)).collect(Collectors.toList());
                requestsWithoutCurrentRequest.addAll(folderRequests);
                requestsWithoutCurrentRequest = requestsWithoutCurrentRequest.stream().filter(StreamUtils.distinctByKey(AbstractEntity::getId)).collect(Collectors.toList());
                this.requestService.addPostfixIfNameIsTaken(requestsWithoutCurrentRequest, (Request)requestObject);
            });
        }
        List<Request> rootFolderRequestObjects = parsedRequests.stream().filter(request -> Objects.isNull(request.getFolderId())).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(rootFolderRequestObjects)) {
            UUID projectId = ((Request)rootFolderRequestObjects.get(0)).getProjectId();
            List<Request> rootFolderRequests = this.requestService.getAllRequestsByProjectIdFolderIdsRequestIds(projectId, null, null);
            rootFolderRequestObjects.forEach(requestObject -> {
                List<Request> requestsWithoutCurrentRequest = rootFolderRequestObjects.stream().filter(request -> !request.equals(requestObject)).collect(Collectors.toList());
                requestsWithoutCurrentRequest.addAll(rootFolderRequests);
                requestsWithoutCurrentRequest = requestsWithoutCurrentRequest.stream().filter(StreamUtils.distinctByKey(AbstractEntity::getId)).collect(Collectors.toList());
                this.requestService.addPostfixIfNameIsTaken(requestsWithoutCurrentRequest, (Request)requestObject);
            });
        }
        rootFolderRequestObjects.addAll(requestsGroupedByFolders.entrySet().stream().flatMap(uuidListEntry -> ((List)uuidListEntry.getValue()).stream()).collect(Collectors.toList()));
        this.requestService.saveAll(rootFolderRequestObjects);
    }

    public void importFiles(ExportImportData importData, Path workDir) {
        log.info("start importFiles(workDir: {})", (Object)workDir);
        Map<UUID, Path> list = this.getFileDescriptors(workDir, "Files");
        log.debug("importFiles list: {}", list);
        list.forEach((id, path) -> {
            FileInfo fileInfo;
            log.debug("importFiles start import id: {}", id);
            if (importData.isCreateNewProject() || importData.isInterProjectImport()) {
                HashMap map = new HashMap(importData.getReplacementMap());
                fileInfo = (FileInfo)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(path, FileInfo.class, map);
            } else {
                fileInfo = (FileInfo)this.objectLoaderFromDiskService.loadFileAsObject(path, FileInfo.class);
            }
            log.debug("importFiles import fileData: {}", (Object)fileInfo);
            if (fileInfo == null) {
                log.info("Selected file is no a file descriptor. Path {}", (Object)path.toString());
                return;
            }
            Path filePath = path.getParent().resolve(id.toString());
            try (InputStream inputStream = Files.newInputStream(filePath, new OpenOption[0]);){
                this.gridFsService.saveByFileInfo(fileInfo, inputStream);
            }
            catch (Exception e) {
                log.error("Cannot read file {}. File Data {}", new Object[]{filePath, fileInfo, e});
            }
        });
        log.info("end importFiles()");
    }

    private Map<UUID, Path> getFileDescriptors(Path workDir, String folderName) {
        Path dirWithObjects = workDir.resolve(folderName);
        log.debug("start getListOfObjectIdByFolder(dirWithObjects: {})", (Object)dirWithObjects);
        HashMap<UUID, Path> res = new HashMap<UUID, Path>();
        try (Stream<Path> result = Files.find(dirWithObjects, 3, (path, basicFileAttributes) -> basicFileAttributes.isRegularFile() && path.getFileName().toString().matches(DESCRIPTOR_FILE_NAME_REGEXP), new FileVisitOption[0]);){
            result.forEach(pathToFile -> {
                UUID fileId;
                try {
                    fileId = UUID.fromString(pathToFile.getFileName().toString().split("\\.")[0]);
                }
                catch (IllegalArgumentException e) {
                    log.warn("Can't get uuid from filename.", (Throwable)e);
                    return;
                }
                res.put(fileId, (Path)pathToFile);
            });
        }
        catch (Exception e) {
            log.error("Cannot find dir {}", (Object)dirWithObjects, (Object)e);
        }
        log.debug("end getListOfObjectIdByFolder(): {}", res);
        return res;
    }

    private Request loadRequest(Path filePath, Map<UUID, UUID> replacementMap, boolean isReplacement, JSONParser parser) {
        Request request;
        if (isReplacement) {
            log.debug("Load request by path [{}] with replacementMap: {}", (Object)filePath, replacementMap);
            request = (Request)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(filePath, Request.class, replacementMap, true, false);
        } else {
            log.debug("Load request by path [{}] without replacementMap", (Object)filePath);
            request = (Request)this.objectLoaderFromDiskService.loadFileAsObject(filePath, Request.class);
        }
        if (Objects.nonNull(request)) {
            log.debug("RequestAuthorization parsing for requestId = {}", (Object)request.getId());
            request.setAuthorization(this.parseRequestAuthorization(filePath, replacementMap, isReplacement, request.getAuthorization(), parser));
            return request;
        }
        return null;
    }

    public RequestAuthorization parseRequestAuthorization(Path filePath, Map<UUID, UUID> replacementMap, boolean isReplacement, RequestAuthorization requestAuthorization, JSONParser parser) {
        if (Objects.nonNull(requestAuthorization)) {
            RequestAuthorizationType authType = requestAuthorization.getType();
            switch (authType) {
                case OAUTH2: {
                    return this.prepareRequestAuth(filePath, replacementMap, isReplacement, parser, OAuth2RequestAuthorization.class);
                }
                case BASIC: {
                    return this.prepareRequestAuth(filePath, replacementMap, isReplacement, parser, BasicRequestAuthorization.class);
                }
                case BEARER: {
                    return this.prepareRequestAuth(filePath, replacementMap, isReplacement, parser, BearerRequestAuthorization.class);
                }
                case INHERIT_FROM_PARENT: {
                    return this.prepareRequestAuth(filePath, replacementMap, isReplacement, parser, InheritFromParentRequestAuthorization.class);
                }
            }
            log.warn("Request with type {} will not be parsing", (Object)authType);
        }
        log.debug("Request authorization not found in {}", (Object)filePath);
        return requestAuthorization;
    }

    public <T extends RequestAuthorization> T prepareRequestAuth(Path filePath, Map<UUID, UUID> replacementMap, boolean isReplacement, JSONParser parser, Class<T> neededClass) {
        try {
            log.debug("Read request from {}", (Object)filePath);
            String requestString = IOUtils.toString((InputStream)Files.newInputStream(filePath, new OpenOption[0]));
            JsonObject parsedRequest = new JsonObject(parser.parse(requestString));
            JsonObject authorizationJson = parsedRequest.getObject("authorization");
            log.debug("Map parsed request authorization into OAuth2RequestAuthorization");
            RequestAuthorization parsedRequestAuthorization = (RequestAuthorization)this.modelMapper.map((Object)authorizationJson.getObj(), neededClass);
            UUID parsedRequestAuthorizationId = parsedRequestAuthorization.getId();
            if (isReplacement && replacementMap.containsKey(parsedRequestAuthorizationId)) {
                log.debug("Replace request authorization id");
                parsedRequestAuthorization.setId(replacementMap.get(parsedRequestAuthorizationId));
            }
            return (T)parsedRequestAuthorization;
        }
        catch (IOException | ParseException e) {
            log.error("Can't get authorization from file {}.", (Object)filePath, (Object)e);
            return null;
        }
    }

    public Map<UUID, UUID> getSourceTargetMap(Path workDir, Map<UUID, UUID> replacementMap) {
        log.debug("Get source target replacement map");
        HashMap<UUID, UUID> result = new HashMap<UUID, UUID>();
        Map<UUID, Path> objectsToImport = this.getListOfRequests(workDir);
        objectsToImport.forEach((uuid, filePath) -> {
            Request requestObject = (Request)this.objectLoaderFromDiskService.loadFileAsObjectWithReplacementMap(filePath, Request.class, replacementMap);
            Request existingObject = this.requestService.getByProjectIdAndSourceId(requestObject.getProjectId(), (UUID)uuid);
            if (existingObject == null) {
                log.debug("Request by projectId: [{}] and sourceId: [{}] not found", (Object)requestObject.getProjectId(), uuid);
                log.debug("Put {}: null to replacementMap", uuid);
                result.put((UUID)uuid, (UUID)null);
            } else {
                log.debug("Request by projectId: [{}] and sourceId: [{}] found", (Object)requestObject.getProjectId(), uuid);
                log.debug("Put {}: {} to replacementMap", uuid, (Object)existingObject.getId());
                result.put((UUID)uuid, existingObject.getId());
            }
        });
        return result;
    }

    public Map<UUID, UUID> getReplacementMap(Path workDir) {
        log.debug("Get replacementMap for requests");
        HashMap<UUID, UUID> result = new HashMap<UUID, UUID>();
        Map<UUID, Path> objectsToImport = this.getListOfRequests(workDir);
        objectsToImport.forEach((uuid, filePath) -> {
            Request requestObject = (Request)this.objectLoaderFromDiskService.loadFileAsObject(filePath, Request.class);
            RequestAuthorization auth = requestObject.getAuthorization();
            if (auth != null) {
                UUID newId = UUID.randomUUID();
                log.debug("Put new uuid for authorization - {}: {}", (Object)auth.getId(), (Object)newId);
                result.put(auth.getId(), newId);
            }
        });
        return result;
    }

    private Map<UUID, Path> getListOfRequests(Path dir) {
        Map objectsToImport = this.objectLoaderFromDiskService.getListOfObjects(dir, HttpRequest.class);
        return objectsToImport;
    }

    public RequestImporterService(ObjectLoaderFromDiskService objectLoaderFromDiskService, RequestService requestService, ModelMapper modelMapper, GridFsService gridFsService) {
        this.objectLoaderFromDiskService = objectLoaderFromDiskService;
        this.requestService = requestService;
        this.modelMapper = modelMapper;
        this.gridFsService = gridFsService;
    }
}

