/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.enums.http;

import com.fasterxml.jackson.annotation.JsonValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum RequestBodyType {
    JSON("JSON", Collections.singletonList("application/json")),
    GraphQL("GraphQL", Collections.singletonList("application/json")),
    XML("XML", Arrays.asList("application/xml", "text/xml")),
    TEXT("TEXT", Collections.singletonList("text/plain")),
    URLENCODED("URLEncoded", Collections.singletonList("application/xml")),
    Binary("Binary", Collections.singletonList("application/octet-stream")),
    FORM_DATA("Form-data", Collections.singletonList("multipart/form-data")),
    Velocity("Velocity", Collections.emptyList()),
    Wireshark("Wireshark", Collections.emptyList()),
    HTML("HTML", Collections.singletonList("text/html")),
    JavaScript("JavaScript", Collections.singletonList("application/javascript"));

    private static final Logger log;
    private final String name;
    private List<String> contentTypes;

    private RequestBodyType(String name) {
        this.name = name;
    }

    private RequestBodyType(String name, List<String> contentTypes) {
        this.name = name;
        this.contentTypes = contentTypes;
    }

    @JsonValue
    public String getName() {
        return this.name;
    }

    public static RequestBodyType valueOfIgnoreCase(String name) {
        for (RequestBodyType value : RequestBodyType.values()) {
            if (!value.name().equalsIgnoreCase(name)) continue;
            return value;
        }
        return null;
    }

    public static RequestBodyType valueOfContentType(String contentType, String contentDisposition) {
        log.info("Content type when define type : Content-Type: {}, Content-Disposition: {}", (Object)contentType, (Object)contentDisposition);
        if (!StringUtils.isEmpty((CharSequence)contentDisposition)) {
            return Binary;
        }
        if (StringUtils.isEmpty((CharSequence)contentType)) {
            return null;
        }
        for (RequestBodyType value : RequestBodyType.values()) {
            if (value.getContentTypes() == null) {
                return null;
            }
            String clearedContentType = contentType.split(";")[0];
            if (!value.getContentTypes().stream().anyMatch(clearedContentType::equalsIgnoreCase)) continue;
            return value;
        }
        return null;
    }

    public List<String> getContentTypes() {
        return this.contentTypes;
    }

    static {
        log = LoggerFactory.getLogger(RequestBodyType.class);
    }
}

