/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.facade;

import java.util.UUID;
import org.modelmapper.ModelMapper;
import org.qubership.atp.itf.lite.backend.model.api.request.FolderTreeSearchRequest;
import org.qubership.atp.itf.lite.backend.model.documentation.AbstractDocumentation;
import org.qubership.atp.itf.lite.backend.model.documentation.RequestDocumentation;
import org.qubership.atp.itf.lite.backend.model.documentation.RequestEntityEditDocumentation;
import org.qubership.atp.itf.lite.backend.model.documentation.TreeFolderDocumentationResponse;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.service.DocumentationService;
import org.qubership.atp.itf.lite.backend.service.RequestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class DocumentationFacade {
    private static final Logger log = LoggerFactory.getLogger(DocumentationFacade.class);
    private final RequestService requestService;
    private final DocumentationService documentationService;
    private final ModelMapper modelMapper;

    public ResponseEntity<TreeFolderDocumentationResponse> getDocumentationByFolder(FolderTreeSearchRequest request, int page, int pageSize) {
        return ResponseEntity.ok((Object)this.documentationService.getDescription(request, page, pageSize));
    }

    public ResponseEntity<RequestDocumentation> getRequestDocumentation(UUID requestId) {
        Request temporaryRequest = this.requestService.getRequest(requestId);
        return ResponseEntity.ok((Object)((RequestDocumentation)this.modelMapper.map((Object)temporaryRequest, RequestDocumentation.class)));
    }

    public ResponseEntity<AbstractDocumentation> editDocumentation(UUID entityId, RequestEntityEditDocumentation request) {
        switch (request.getType()) {
            case REQUEST: {
                return ResponseEntity.ok((Object)this.documentationService.editDocumentationRequest(entityId, request));
            }
            case FOLDER: {
                return ResponseEntity.ok((Object)this.documentationService.editDocumentationFolder(entityId, request));
            }
        }
        log.error("Not Correctly type for edit documentation: {}", (Object)request.getType());
        return null;
    }

    public DocumentationFacade(RequestService requestService, DocumentationService documentationService, ModelMapper modelMapper) {
        this.requestService = requestService;
        this.documentationService = documentationService;
        this.modelMapper = modelMapper;
    }
}

