/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.feign.service;

import java.util.List;
import java.util.UUID;
import org.qubership.atp.itf.lite.backend.feign.clients.CatalogueExecuteRequestFeignClient;
import org.qubership.atp.itf.lite.backend.feign.clients.CatalogueProjectFeignClient;
import org.qubership.atp.itf.lite.backend.feign.dto.CertificateDto;
import org.qubership.atp.itf.lite.backend.feign.dto.ExecuteRequestDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.core.io.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;

@Service
public class CatalogueService {
    private static final Logger log = LoggerFactory.getLogger(CatalogueService.class);
    private final CatalogueProjectFeignClient catalogueFeignClient;
    private final CatalogueExecuteRequestFeignClient catalogueExecuteRequestFeignClient;

    public List<UUID> execute(String authorization, ExecuteRequestDto executeRequestDto) {
        return (List)this.catalogueExecuteRequestFeignClient.execute(authorization, executeRequestDto).getBody();
    }

    @Cacheable(value={"ATP_ITF_LITE_PROJECT_CERT"}, key="#projectId", condition="#projectId != null", sync=true)
    public ResponseEntity<CertificateDto> getCertificate(UUID projectId) {
        log.info("Takes actual certificate information from catalogue");
        try {
            return this.catalogueFeignClient.getCertificate(projectId);
        }
        catch (Exception e) {
            log.warn("Can't get project certificate. See error message for more details: {}", (Object)e.getMessage(), (Object)e);
            return null;
        }
    }

    @CacheEvict(value={"ATP_ITF_LITE_PROJECT_CERT"}, key="#projectId")
    public void evictProjectCertificateCacheByProjectId(UUID projectId) {
        log.info("Project certificate cache for projectId = '{}' has been evicted", (Object)projectId);
    }

    public ResponseEntity<Resource> downloadFile(String fileId) {
        log.info("Download file with {} from catalogue", (Object)fileId);
        return this.catalogueFeignClient.downloadFile(fileId);
    }

    public CatalogueService(CatalogueProjectFeignClient catalogueFeignClient, CatalogueExecuteRequestFeignClient catalogueExecuteRequestFeignClient) {
        this.catalogueFeignClient = catalogueFeignClient;
        this.catalogueExecuteRequestFeignClient = catalogueExecuteRequestFeignClient;
    }
}

