/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.feign.service;

import clover.org.apache.commons.lang3.StringUtils;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import feign.FeignException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.qubership.atp.auth.springbootstarter.feign.exception.FeignClientException;
import org.qubership.atp.crypt.exception.AtpDecryptException;
import org.qubership.atp.crypt.exception.AtpEncryptException;
import org.qubership.atp.itf.lite.backend.enums.ContextType;
import org.qubership.atp.itf.lite.backend.feign.clients.JsScriptEngineFeignClient;
import org.qubership.atp.itf.lite.backend.feign.dto.HeaderDto;
import org.qubership.atp.itf.lite.backend.feign.dto.HttpResponseExceptionTypeEnum;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanCookieDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanExecuteScriptRequestDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanExecuteScriptResponseDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanExecuteScriptResponseTestResultsInnerDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanExecuteScriptResponseTestResultsInnerErrorDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanPostmanResponseDto;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionResponse;
import org.qubership.atp.itf.lite.backend.model.context.SaveRequestResolvingContext;
import org.qubership.atp.itf.lite.backend.model.entities.Cookie;
import org.qubership.atp.itf.lite.backend.service.EncryptionService;
import org.qubership.atp.itf.lite.backend.utils.CookieUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Service;

@Service
public class JsScriptEngineService {
    private static final Logger log = LoggerFactory.getLogger(JsScriptEngineService.class);
    private final JsScriptEngineFeignClient jsScriptEngineFeignClient;
    private final EncryptionService encryptionService;
    private final ThreadLocal<List<String>> globalsEncrypted = new ThreadLocal();
    private final ThreadLocal<List<String>> collectionVariablesEncrypted = new ThreadLocal();
    private final ThreadLocal<List<String>> environmentEncrypted = new ThreadLocal();
    private final ThreadLocal<List<String>> iterationDataEncrypted = new ThreadLocal();
    private final ThreadLocal<List<String>> variablesEncrypted = new ThreadLocal();
    private final String failToCreatePostmanSandboxContextReasonCode = "ITFLSE-0001";

    public PostmanExecuteScriptResponseDto evaluateRequestPostScript(RequestEntitySaveRequest request, RequestExecutionResponse response, SaveRequestResolvingContext resolvingContext) {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getPostScripts())) {
            return null;
        }
        log.info("Evaluate pre-script for request with id: {}", (Object)request.getId());
        return this.executePostmanScript(false, request, response, resolvingContext);
    }

    public PostmanExecuteScriptResponseDto evaluateRequestPreScript(RequestEntitySaveRequest request, SaveRequestResolvingContext resolvingContext) {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getPreScripts())) {
            return null;
        }
        log.info("Evaluate pre-script for request with id: {}", (Object)request.getId());
        return this.executePostmanScript(true, request, null, resolvingContext);
    }

    private PostmanExecuteScriptResponseDto executePostmanScript(boolean isPreScript, RequestEntitySaveRequest request, RequestExecutionResponse response, SaveRequestResolvingContext resolvingContext) {
        try {
            PostmanExecuteScriptRequestDto postmanExecuteScriptRequestDto = this.generateRequestToJsEngine(isPreScript, request, response, resolvingContext);
            PostmanExecuteScriptResponseDto jsScriptEngineResponse = (PostmanExecuteScriptResponseDto)this.jsScriptEngineFeignClient.executePostmanScript(postmanExecuteScriptRequestDto).getBody();
            PostmanDto postmanDto = jsScriptEngineResponse.getPostman();
            request.setCookies(CookieUtils.convertPostmanCookieDtoListToCookieList(postmanDto.getCookies() != null ? postmanDto.getCookies() : new ArrayList<PostmanCookieDto>()));
            request.updateFromPostmanRequest(postmanDto.getPostmanRequest());
            if (!isPreScript) {
                response.updateFromPostmanResponse(postmanDto.getPostmanResponse());
            }
            resolvingContext.setGlobals(this.updateContext(ContextType.GLOBALS, postmanDto.getGlobals()));
            resolvingContext.setCollectionVariables(this.updateContext(ContextType.COLLECTION_VARIABLES, postmanDto.getCollectionVariables()));
            resolvingContext.setEnvironment(this.updateContext(ContextType.ENVIRONMENT, postmanDto.getEnvironment()));
            resolvingContext.setIterationData(this.updateContext(ContextType.ITERATION_DATA, postmanDto.getIterationData()));
            resolvingContext.setVariables(this.updateContext(ContextType.VARIABLES, postmanDto.getVariables()));
            log.debug("All results context {}, isPreScript? {}", (Object)resolvingContext, (Object)isPreScript);
            return jsScriptEngineResponse;
        }
        catch (AtpDecryptException decryptEx) {
            return this.generateExecuteScriptErrorResponse("DECRYPT CONTEXT BEFORE EXECUTION", decryptEx.getMessage(), (Exception)((Object)decryptEx), HttpResponseExceptionTypeEnum.DECRYPT_EXCEPTION);
        }
        catch (AtpEncryptException encryptEx) {
            return this.generateExecuteScriptErrorResponse("ENCRYPT CONTEXT AFTER EXECUTION", encryptEx.getMessage(), (Exception)((Object)encryptEx), HttpResponseExceptionTypeEnum.ENCRYPT_EXCEPTION);
        }
        catch (FeignClientException feignClientEx) {
            String errorMessage = feignClientEx.getMessage();
            HttpResponseExceptionTypeEnum exceptionType = HttpResponseExceptionTypeEnum.EXECUTION_EXCEPTION;
            if (feignClientEx.getStatus().equals(HttpStatus.SERVICE_UNAVAILABLE.value())) {
                exceptionType = HttpResponseExceptionTypeEnum.UNAVAILABLE_EXCEPTION;
            }
            try {
                String scriptEngineReason;
                JsonObject feignClientExceptionAsJson = JsonParser.parseString((String)feignClientEx.getErrorMessage()).getAsJsonObject();
                if (feignClientExceptionAsJson.has("reason") && "ITFLSE-0001".equals(scriptEngineReason = feignClientExceptionAsJson.get("reason").getAsString())) {
                    exceptionType = HttpResponseExceptionTypeEnum.POSTMAN_SANDBOX_CONTEXT_EXCEPTION;
                }
                if (feignClientExceptionAsJson.has("message")) {
                    errorMessage = feignClientExceptionAsJson.get("message").getAsString();
                }
                if (feignClientExceptionAsJson.has("details") && feignClientExceptionAsJson.get("details").isJsonObject()) {
                    String errorMessageFromJson = "";
                    if (feignClientExceptionAsJson.get("details").getAsJsonObject().has("name")) {
                        errorMessageFromJson = feignClientExceptionAsJson.get("details").getAsJsonObject().get("name").getAsString();
                    }
                    if (feignClientExceptionAsJson.get("details").getAsJsonObject().has("message")) {
                        errorMessageFromJson = errorMessageFromJson + (StringUtils.isEmpty((CharSequence)errorMessageFromJson) ? feignClientExceptionAsJson.get("details").getAsJsonObject().get("message").getAsString() : ": " + feignClientExceptionAsJson.get("details").getAsJsonObject().get("message").getAsString());
                    }
                    if (!StringUtils.isEmpty((CharSequence)errorMessageFromJson)) {
                        errorMessage = errorMessageFromJson;
                    }
                }
            }
            catch (JsonSyntaxException | IllegalStateException exception) {
                log.warn("Can't parse feign client exception message into json object.", exception);
            }
            return this.generateExecuteScriptErrorResponse("[FEIGN] EXECUTE JS SCRIPT", errorMessage, (Exception)((Object)feignClientEx), exceptionType);
        }
        catch (FeignException feignEx) {
            return this.generateExecuteScriptErrorResponse("JS SCRIPT NOT AVAILABLE", feignEx.getMessage(), (Exception)((Object)feignEx), HttpResponseExceptionTypeEnum.EXECUTION_EXCEPTION);
        }
        catch (Exception e) {
            return this.generateExecuteScriptErrorResponse("[OTHER] EXECUTE JS SCRIPT", e.getMessage(), e, HttpResponseExceptionTypeEnum.EXECUTION_EXCEPTION);
        }
    }

    private Map<String, Object> generateContext(ContextType type, Map<String, Object> originContext) throws AtpDecryptException {
        HashMap<String, Object> targetContext = new HashMap<String, Object>();
        for (Map.Entry<String, Object> c : originContext.entrySet()) {
            if (Objects.nonNull(c.getValue()) && this.encryptionService.isEncrypted(c.getValue().toString())) {
                switch (type) {
                    case GLOBALS: {
                        if (this.globalsEncrypted.get() == null) {
                            this.globalsEncrypted.set(new ArrayList());
                        }
                        this.globalsEncrypted.get().add(c.getKey());
                        break;
                    }
                    case COLLECTION_VARIABLES: {
                        if (this.collectionVariablesEncrypted.get() == null) {
                            this.collectionVariablesEncrypted.set(new ArrayList());
                        }
                        this.collectionVariablesEncrypted.get().add(c.getKey());
                        break;
                    }
                    case ENVIRONMENT: {
                        if (this.environmentEncrypted.get() == null) {
                            this.environmentEncrypted.set(new ArrayList());
                        }
                        this.environmentEncrypted.get().add(c.getKey());
                        break;
                    }
                    case ITERATION_DATA: {
                        if (this.iterationDataEncrypted.get() == null) {
                            this.iterationDataEncrypted.set(new ArrayList());
                        }
                        this.iterationDataEncrypted.get().add(c.getKey());
                        break;
                    }
                    case VARIABLES: {
                        if (this.variablesEncrypted.get() == null) {
                            this.variablesEncrypted.set(new ArrayList());
                        }
                        this.variablesEncrypted.get().add(c.getKey());
                        break;
                    }
                }
                targetContext.put(c.getKey(), this.encryptionService.decrypt(c.getValue().toString()));
                continue;
            }
            targetContext.put(c.getKey(), c.getValue());
        }
        return targetContext;
    }

    private Map<String, Object> updateContext(ContextType type, Map<String, Object> sourceContext) throws AtpEncryptException {
        log.debug("Update context type: {} and sourceContext {}", (Object)type, sourceContext);
        HashMap<String, Object> targetContext = new HashMap<String, Object>();
        List<Object> keysEncrypted = new ArrayList();
        switch (type) {
            case GLOBALS: {
                keysEncrypted = this.globalsEncrypted.get();
                this.globalsEncrypted.remove();
                break;
            }
            case COLLECTION_VARIABLES: {
                keysEncrypted = this.collectionVariablesEncrypted.get();
                this.collectionVariablesEncrypted.remove();
                break;
            }
            case ENVIRONMENT: {
                keysEncrypted = this.environmentEncrypted.get();
                this.environmentEncrypted.remove();
                break;
            }
            case ITERATION_DATA: {
                keysEncrypted = this.iterationDataEncrypted.get();
                this.iterationDataEncrypted.remove();
                break;
            }
            case VARIABLES: {
                keysEncrypted = this.variablesEncrypted.get();
                this.variablesEncrypted.remove();
                break;
            }
        }
        keysEncrypted = keysEncrypted == null ? new ArrayList() : keysEncrypted;
        for (Map.Entry<String, Object> c : sourceContext.entrySet()) {
            if (Objects.nonNull(c.getValue()) && keysEncrypted.contains(c.getKey())) {
                targetContext.put(c.getKey(), this.encryptionService.encrypt(c.getValue().toString()));
                continue;
            }
            targetContext.put(c.getKey(), c.getValue());
        }
        return targetContext;
    }

    private PostmanPostmanResponseDto generatePostmanResponseDto(RequestExecutionResponse itfLiteResponse) {
        return new PostmanPostmanResponseDto().status(itfLiteResponse.getStatusText()).code(Integer.parseInt(itfLiteResponse.getStatusCode())).header(itfLiteResponse.getResponseHeaders().stream().map(h -> new HeaderDto().key(h.getKey()).value(h.getValue())).collect(Collectors.toList())).body(itfLiteResponse.getBody()).responseTime(itfLiteResponse.getDuration().intValue());
    }

    private PostmanExecuteScriptRequestDto generateRequestToJsEngine(boolean isPreScript, RequestEntitySaveRequest request, @Nullable RequestExecutionResponse response, SaveRequestResolvingContext resolvingContext) throws AtpDecryptException {
        log.debug("Generate request to JS engine for request(id: {})", (Object)request.getId());
        PostmanDto postman = new PostmanDto().postmanRequest(request.getPostmanRequest()).globals(this.generateContext(ContextType.GLOBALS, resolvingContext.getGlobals())).collectionVariables(this.generateContext(ContextType.COLLECTION_VARIABLES, resolvingContext.getCollectionVariables())).environment(this.generateContext(ContextType.ENVIRONMENT, resolvingContext.getEnvironment())).iterationData(this.generateContext(ContextType.ITERATION_DATA, resolvingContext.getIterationData())).variables(this.generateContext(ContextType.VARIABLES, resolvingContext.getVariables())).cookies(CookieUtils.convertCookieListToPostmanCookieDtoList(request.getCookies() != null ? request.getCookies() : new ArrayList<Cookie>()));
        if (Objects.nonNull(response)) {
            postman.setPostmanResponse(this.generatePostmanResponseDto(response));
        }
        return new PostmanExecuteScriptRequestDto().projectId(request.getProjectId()).postman(postman).script(isPreScript ? request.getPreScripts() : request.getPostScripts());
    }

    private PostmanExecuteScriptResponseDto generateExecuteScriptErrorResponse(String step, String errorMessage, Exception ex, HttpResponseExceptionTypeEnum httpResponseExceptionType) {
        log.error(errorMessage, (Throwable)ex);
        return new PostmanExecuteScriptResponseDto().testResults(Arrays.asList(new PostmanExecuteScriptResponseTestResultsInnerDto().name(step).index(BigDecimal.valueOf(0L)).passed(false).error(new PostmanExecuteScriptResponseTestResultsInnerErrorDto().message(errorMessage).httpResponseExceptionType(httpResponseExceptionType))));
    }

    public JsScriptEngineService(JsScriptEngineFeignClient jsScriptEngineFeignClient, EncryptionService encryptionService) {
        this.jsScriptEngineFeignClient = jsScriptEngineFeignClient;
        this.encryptionService = encryptionService;
    }
}

