/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.feign.service;

import com.google.gson.Gson;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.adapter.common.AtpRamAdapter;
import org.qubership.atp.adapter.common.adapters.AtpKafkaRamAdapter;
import org.qubership.atp.adapter.common.adapters.providers.RamAdapterProvider;
import org.qubership.atp.adapter.common.context.AtpCompaund;
import org.qubership.atp.adapter.common.context.TestRunContext;
import org.qubership.atp.adapter.common.context.TestRunContextHolder;
import org.qubership.atp.adapter.common.entities.Message;
import org.qubership.atp.adapter.executor.executor.AtpRamWriter;
import org.qubership.atp.auth.springbootstarter.exceptions.AtpException;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.enums.ValueType;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteIllegalTestRunsCountInExecutionRequestException;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteIncorrectImportContextVariablesRequest;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteIncorrectImportRequest;
import org.qubership.atp.itf.lite.backend.exceptions.requests.ItfLiteTestRunsNotFoundException;
import org.qubership.atp.itf.lite.backend.feign.clients.RamExecutionRequestFeignClient;
import org.qubership.atp.itf.lite.backend.feign.clients.RamLogRecordFeignClient;
import org.qubership.atp.itf.lite.backend.feign.clients.RamTestPlansFeignClient;
import org.qubership.atp.itf.lite.backend.feign.clients.RamTestRunsFeignClient;
import org.qubership.atp.itf.lite.backend.feign.dto.ConsoleLogDto;
import org.qubership.atp.itf.lite.backend.feign.dto.ContextVariableDto;
import org.qubership.atp.itf.lite.backend.feign.dto.LogRecordDto;
import org.qubership.atp.itf.lite.backend.feign.dto.LogRecordFilteringRequestDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanExecuteScriptResponseDto;
import org.qubership.atp.itf.lite.backend.feign.dto.RequestDto;
import org.qubership.atp.itf.lite.backend.feign.dto.RequestHeaderDto;
import org.qubership.atp.itf.lite.backend.feign.dto.ResponseDto;
import org.qubership.atp.itf.lite.backend.feign.dto.RestLogRecordDto;
import org.qubership.atp.itf.lite.backend.feign.dto.TestPlanDto;
import org.qubership.atp.itf.lite.backend.feign.dto.TestPlansSearchRequestDto;
import org.qubership.atp.itf.lite.backend.feign.dto.TestRunDto;
import org.qubership.atp.itf.lite.backend.feign.dto.TypeActionDto;
import org.qubership.atp.itf.lite.backend.model.api.request.ContextVariable;
import org.qubership.atp.itf.lite.backend.model.api.request.ExecutionCollectionRequestExecuteRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.HttpRequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.ImportContextRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.ImportFromRamRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.ImportContextResponse;
import org.qubership.atp.itf.lite.backend.model.api.response.JsExecutionResult;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionResponse;
import org.qubership.atp.itf.lite.backend.model.entities.Cookie;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileData;
import org.qubership.atp.itf.lite.backend.model.entities.http.FormDataPart;
import org.qubership.atp.itf.lite.backend.service.GridFsService;
import org.qubership.atp.itf.lite.backend.utils.CookieUtils;
import org.qubership.atp.itf.lite.backend.utils.StreamUtils;
import org.qubership.atp.itf.lite.backend.utils.UrlParsingUtils;
import org.qubership.atp.ram.enums.ExecutionStatuses;
import org.qubership.atp.ram.enums.TestingStatuses;
import org.qubership.atp.ram.enums.TypeAction;
import org.qubership.atp.ram.models.ScriptConsoleLog;
import org.qubership.atp.ram.models.logrecords.parts.Request;
import org.qubership.atp.ram.models.logrecords.parts.RequestHeader;
import org.qubership.atp.ram.models.logrecords.parts.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RamService {
    private static final Logger log = LoggerFactory.getLogger(RamService.class);
    private final RamTestPlansFeignClient testPlansFeignClient;
    private final RamTestRunsFeignClient ramTestRunsFeignClient;
    private final RamLogRecordFeignClient ramLogRecordFeignClient;
    private final RamExecutionRequestFeignClient ramExecutionRequestFeignClient;
    private final GridFsService gridFsService;
    private final String fileDownloadLink;
    private static final String DEFAULT_ITF_LITE_RUN_COLLECTION_TEST_PLAN_NAME = "ITF Lite Default";

    public UUID getDefaultCollectionRunTestPlanId(UUID projectId) {
        List defaultRunCollectionTestPlans = (List)this.testPlansFeignClient.search(new TestPlansSearchRequestDto().name(DEFAULT_ITF_LITE_RUN_COLLECTION_TEST_PLAN_NAME).projectId(projectId)).getBody();
        if (CollectionUtils.isEmpty((Collection)defaultRunCollectionTestPlans)) {
            log.warn("Failed to find default Itf Lite run collection test plan");
            TestPlanDto newTestPlan = new TestPlanDto().name(DEFAULT_ITF_LITE_RUN_COLLECTION_TEST_PLAN_NAME).projectId(projectId);
            log.debug("Creating new default Itf Lite run collection test plan");
            TestPlanDto createdTestPlan = (TestPlanDto)this.testPlansFeignClient.createTestPlan(newTestPlan).getBody();
            if (Objects.nonNull(createdTestPlan)) {
                return createdTestPlan.getUuid();
            }
            throw new AtpException(String.format("Default Test Plan with name \"%s\" not found and cannot be created", DEFAULT_ITF_LITE_RUN_COLLECTION_TEST_PLAN_NAME));
        }
        TestPlanDto existedDefaultTestPlan = (TestPlanDto)StreamUtils.getFirstElem(defaultRunCollectionTestPlans);
        log.debug("Found new default Itf Lite run collection test plan: {}", (Object)existedDefaultTestPlan.getUuid());
        return existedDefaultTestPlan.getUuid();
    }

    public void updateExecutionLogRecordName(ExecutionCollectionRequestExecuteRequest requestExecuteRequest, String newName) {
        Timestamp startDate = Objects.nonNull(requestExecuteRequest.getSection().getStartDate()) ? requestExecuteRequest.getSection().getStartDate() : new Timestamp(new Date().getTime());
        AtpRamWriter.getAtpRamWriter().getAdapter().updateExecutionStatus(requestExecuteRequest.getSection().getSectionId(), ExecutionStatuses.IN_PROGRESS.name(), startDate, newName);
    }

    public List<org.qubership.atp.ram.models.logrecords.parts.ContextVariable> getContextVariables(Map<String, Object> beforeContext, Map<String, Object> afterContext) {
        ArrayList<org.qubership.atp.ram.models.logrecords.parts.ContextVariable> contextVariables = new ArrayList<org.qubership.atp.ram.models.logrecords.parts.ContextVariable>();
        if (!CollectionUtils.isEmpty(beforeContext)) {
            beforeContext.forEach((k, v) -> contextVariables.add(new org.qubership.atp.ram.models.logrecords.parts.ContextVariable(k, Objects.isNull(v) ? null : v.toString(), CollectionUtils.isEmpty((Map)afterContext) || Objects.isNull(afterContext.get(k)) ? null : afterContext.get(k).toString())));
        }
        if (!CollectionUtils.isEmpty(afterContext)) {
            afterContext.forEach((k, v) -> {
                if (CollectionUtils.isEmpty((Map)beforeContext) || !beforeContext.containsKey(k)) {
                    contextVariables.add(new org.qubership.atp.ram.models.logrecords.parts.ContextVariable(k, null, Objects.isNull(v) ? null : v.toString()));
                }
            });
        }
        return contextVariables;
    }

    public TestRunContext provideInfo(ExecutionCollectionRequestExecuteRequest requestExecuteRequest) {
        TestRunContext ram2Context = TestRunContextHolder.getContext((String)requestExecuteRequest.getTestRunId().toString());
        log.info("Test run ID from context = {}", (Object)ram2Context.getTestRunId());
        ram2Context.setAtpTestRunId(requestExecuteRequest.getTestRunId().toString());
        ram2Context.setAtpExecutionRequestId(requestExecuteRequest.getExecutionRequestId().toString());
        ram2Context.setAtpCompaund(this.updateCompoundStatuses(ram2Context.getAtpCompaund(), requestExecuteRequest.getSection()));
        ram2Context.setTestPlanId(requestExecuteRequest.getTestPlanId().toString());
        ram2Context.setProjectId(requestExecuteRequest.getProjectId().toString());
        ram2Context.getSections().clear();
        log.info("ER_INFO: {}", (Object)ram2Context.getAtpExecutionRequestId());
        log.info("PROJECT_TESTPLAN_INFO: {} {}", (Object)ram2Context.getProjectId(), (Object)ram2Context.getTestPlanId());
        log.info("Section ID [{}]", (Object)ram2Context.getCurrentSectionId());
        AtpRamWriter.getAtpRamWriter().createContext(requestExecuteRequest.getTestRunId().toString());
        return ram2Context;
    }

    private AtpCompaund updateCompoundStatuses(AtpCompaund contextCompaund, AtpCompaund requestCompaund) {
        try {
            HashMap<String, AtpCompaund> lastCompaundTable = this.compaundToHash(contextCompaund);
            AtpCompaund currentCompaund = requestCompaund;
            while (Objects.nonNull(currentCompaund)) {
                AtpCompaund currentRequestCompaund = lastCompaundTable.get(currentCompaund.getSectionId());
                if (currentRequestCompaund != null && (currentCompaund.getTestingStatuses() == null || TestingStatuses.UNKNOWN.equals((Object)currentCompaund.getTestingStatuses()))) {
                    currentCompaund.setTestingStatuses(currentRequestCompaund.getTestingStatuses());
                    log.trace("Set compaund {} to status {}", (Object)currentCompaund.getSectionId(), (Object)currentCompaund.getTestingStatuses());
                }
                currentCompaund = currentCompaund.getParentSection();
            }
        }
        catch (NullPointerException e) {
            log.error("Invalid compaund, unable to update status");
        }
        return requestCompaund;
    }

    private HashMap<String, AtpCompaund> compaundToHash(AtpCompaund contextCompaund) {
        HashMap<String, AtpCompaund> result = new HashMap<String, AtpCompaund>();
        AtpCompaund currentCompaund = contextCompaund;
        while (Objects.nonNull(currentCompaund)) {
            result.put(currentCompaund.getSectionId(), currentCompaund);
            currentCompaund = currentCompaund.getParentSection();
        }
        return result;
    }

    public void updateMessageAndTestingStatus(String message, TestingStatuses status) {
        AtpRamWriter.getAtpRamWriter().updateMessageTestingStatusAndFiles(message, status, null);
    }

    public void writeRequestExecutionResult(UUID transportLogRecordId, RequestEntitySaveRequest request, RequestExecutionResponse requestExecutionResponse, Exception errorMessage, TestingStatuses testingStatus) {
        log.debug("Write LogRecord into RAM adapter");
        Message resultMessage = new Message(transportLogRecordId.toString(), null, request.getName(), "", testingStatus.toString(), TypeAction.TRANSPORT.toString(), false);
        if (errorMessage != null) {
            resultMessage.setMessage(errorMessage.getMessage());
        }
        resultMessage.setRequest(this.createLogRecordPartsRequest(request, requestExecutionResponse, resultMessage.getUuid()));
        resultMessage.setResponse(this.createLogRecordPartsResponse(request, requestExecutionResponse));
        resultMessage.setProtocolType(request.getTransportType().toString());
        resultMessage.setItfLiteRequestId(request.getId());
        resultMessage.setIsPreScriptPresent(Boolean.valueOf(Strings.isNotBlank((String)request.getPreScripts())));
        resultMessage.setIsPostScriptPresent(Boolean.valueOf(Strings.isNotBlank((String)request.getPostScripts())));
        this.setTimestampInMessage(requestExecutionResponse, resultMessage);
        log.debug("Send rest message with id = {} into ram adapter", (Object)resultMessage.getUuid());
        AtpRamWriter atpRamWriter = AtpRamWriter.getAtpRamWriter();
        atpRamWriter.writeLogRecordWithParentSections(arg_0 -> ((AtpRamAdapter)atpRamWriter.getAdapter()).restMessage(arg_0), resultMessage);
    }

    private void setTimestampInMessage(RequestExecutionResponse requestExecutionResponse, Message resultMessage) {
        if (requestExecutionResponse != null) {
            resultMessage.setStartDate(requestExecutionResponse.getStartedWhen() != null ? new Timestamp(requestExecutionResponse.getStartedWhen().getTime()) : null);
            resultMessage.setEndDate(requestExecutionResponse.getExecutedWhen() != null ? new Timestamp(requestExecutionResponse.getExecutedWhen().getTime()) : null);
        }
    }

    public void writeConsoleLogs(UUID transportRecordId, String preScript, String postScript, List<ConsoleLogDto> consoleLogs) {
        if (preScript != null || postScript != null) {
            AtpKafkaRamAdapter atpKafkaRamAdapter = (AtpKafkaRamAdapter)RamAdapterProvider.getNewAdapter((String)"kafka");
            atpKafkaRamAdapter.sendScriptConsoleLogs(consoleLogs.stream().map(c -> new ScriptConsoleLog(c.getMessage(), c.getTimestamp(), c.getLevel())).collect(Collectors.toList()), preScript, postScript, transportRecordId.toString());
        }
    }

    public JsExecutionResult writeTestsResults(PostmanExecuteScriptResponseDto jsExecutionResult, boolean isPreScript) {
        JsExecutionResult returnValue = new JsExecutionResult(true, null);
        if (Objects.nonNull(jsExecutionResult)) {
            returnValue.setConsoleLogs(jsExecutionResult.getConsoleLogs());
            if (Objects.nonNull(jsExecutionResult.getTestResults())) {
                log.info("Write JS script execution into RAM adapter");
                jsExecutionResult.getTestResults().forEach(testResult -> {
                    boolean isFailed;
                    log.debug("Logging JS script execution into RAM Adapter: {}", testResult);
                    boolean bl = isFailed = testResult.getPassed() == false || testResult.getError() != null;
                    if (isFailed) {
                        returnValue.setPassed(false);
                    }
                    String testingStatus = isFailed ? "FAILED" : "PASSED";
                    String message = isFailed ? testResult.getError().getMessage() : "";
                    Message resultMessage = new Message(null, null, testResult.getName(), message, testingStatus, TypeAction.TECHNICAL.toString(), false);
                    log.info("Send rest message with id = {} into ram adapter", (Object)resultMessage.getUuid());
                    AtpRamWriter atpRamWriter = AtpRamWriter.getAtpRamWriter();
                    atpRamWriter.writeLogRecordWithParentSections(arg_0 -> ((AtpRamAdapter)atpRamWriter.getAdapter()).message(arg_0), resultMessage);
                });
            }
        }
        return returnValue;
    }

    private Request createLogRecordPartsRequest(RequestEntitySaveRequest request, RequestExecutionResponse requestExecutionResponse, String logRecordId) {
        Request logRecordPartsRequest = new Request();
        if (Objects.nonNull(requestExecutionResponse) && Objects.nonNull(requestExecutionResponse.getStartedWhen())) {
            logRecordPartsRequest.setTimestamp(new Timestamp(requestExecutionResponse.getStartedWhen().getTime()));
        }
        if (TransportType.REST.equals((Object)request.getTransportType()) || TransportType.SOAP.equals((Object)request.getTransportType())) {
            HttpRequestEntitySaveRequest httpRequest = (HttpRequestEntitySaveRequest)request;
            if (Objects.nonNull(httpRequest.getBody())) {
                StringJoiner sj = new StringJoiner("\n");
                FileData fileData = httpRequest.getFile();
                this.prepareRequestBody(sj, logRecordId, httpRequest.getBody(), fileData, logRecordPartsRequest);
                logRecordPartsRequest.setBody(sj.toString());
            }
            if (Objects.nonNull(httpRequest.getUrl())) {
                logRecordPartsRequest.setEndpoint(httpRequest.getUrlWithQueryParameters());
            }
            if (Objects.nonNull((Object)httpRequest.getHttpMethod())) {
                logRecordPartsRequest.setMethod(httpRequest.getHttpMethod().toString());
            }
            if (!CollectionUtils.isEmpty(httpRequest.getRequestHeaders())) {
                logRecordPartsRequest.setHeadersList(httpRequest.getRequestHeaders().stream().map(headerPair -> new RequestHeader(headerPair.getKey(), headerPair.getValue(), "")).collect(Collectors.toList()));
            }
        }
        return logRecordPartsRequest;
    }

    private void prepareRequestBody(StringJoiner sj, String logRecordId, RequestBody body, FileData binary, Request logRecordPartsRequest) {
        if (body.getType() != null) {
            switch (body.getType()) {
                case Binary: {
                    if (Objects.nonNull(binary)) {
                        sj.add(this.createLinkToDownloadFile(logRecordId, null, binary));
                        AtpRamWriter.getAtpRamWriter().uploadFileForLogRecord(logRecordId, (InputStream)new ByteArrayInputStream(binary.getContent()), binary.getFileName());
                    }
                    logRecordPartsRequest.setHtmlBody(true);
                    return;
                }
                case FORM_DATA: {
                    List<FormDataPart> fdps = body.getFormDataBody();
                    if (!CollectionUtils.isEmpty(fdps)) {
                        fdps.forEach(fdp -> this.addFromDataPart(sj, logRecordId, (FormDataPart)fdp));
                    }
                    logRecordPartsRequest.setHtmlBody(true);
                    return;
                }
            }
        }
        sj.add(body.getContent() == null ? "" : body.getContent());
    }

    private void addFromDataPart(StringJoiner sj, String logRecordId, FormDataPart fdp) {
        if (ValueType.TEXT.equals((Object)fdp.getType())) {
            sj.add(String.format("%s: %s", fdp.getKey(), fdp.getValue()));
        } else {
            UUID fileId = fdp.getFileId();
            if (Objects.nonNull(fileId)) {
                Optional<FileData> optFile = this.gridFsService.downloadFileByFileId(fileId);
                if (optFile.isPresent()) {
                    FileData file = optFile.get();
                    sj.add(String.format("%s: %s", fdp.getKey(), this.createLinkToDownloadFile(logRecordId, fdp.getFileId(), file)));
                    AtpRamWriter.getAtpRamWriter().uploadFileForLogRecord(logRecordId, (InputStream)new ByteArrayInputStream(file.getContent()), fdp.getFileId().toString());
                }
            } else {
                sj.add(fdp.getKey() + ":");
            }
        }
    }

    private String createLinkToDownloadFile(String logRecordId, @Nullable UUID fileId, FileData file) {
        StringBuilder sb = new StringBuilder();
        sb.append("<a href=").append(this.fileDownloadLink).append("/api/logrecords/file/").append(logRecordId).append("?fileName=");
        if (Objects.nonNull(fileId)) {
            sb.append(fileId);
        } else {
            sb.append(file.getFileName());
        }
        sb.append(" target=\"_blank\">").append(file.getFileName()).append("</a>");
        return sb.toString();
    }

    private void loadFileForLogRecord(FileData fileData, Request logRecordPartsRequest, String logRecordId, HttpRequestEntitySaveRequest httpRequest) {
        if (fileData != null) {
            StringJoiner body = new StringJoiner(httpRequest.getBody() == null ? "" : httpRequest.getBody().getContent() + "\n");
            body.add("<a href=").add(this.fileDownloadLink).add("/api/logrecords/file/").add(logRecordId).add(">").add(fileData.getFileName()).add("</a>");
            logRecordPartsRequest.setBody(body.toString());
            AtpRamWriter.getAtpRamWriter().uploadFileForLogRecord(logRecordId, (InputStream)new ByteArrayInputStream(fileData.getContent()), fileData.getFileName());
        }
    }

    private Response createLogRecordPartsResponse(RequestEntitySaveRequest request, RequestExecutionResponse requestExecutionResponse) {
        Response response = new Response();
        if (Objects.nonNull(requestExecutionResponse) && Objects.nonNull(requestExecutionResponse.getExecutedWhen())) {
            response.setTimestamp(new Timestamp(requestExecutionResponse.getExecutedWhen().getTime()));
        } else {
            log.debug("requestExecutionResponse's executedWhen is null. Set current time in response");
            response.setTimestamp(new Timestamp(new Date().getTime()));
        }
        if (Objects.nonNull(requestExecutionResponse)) {
            response.setBody(requestExecutionResponse.getBody());
            response.setCode(requestExecutionResponse.getStatusCode());
            if (Objects.nonNull(requestExecutionResponse.getResponseHeaders())) {
                response.setHeadersList(requestExecutionResponse.getResponseHeaders().stream().map(headerPair -> new RequestHeader(headerPair.getKey(), headerPair.getValue(), "")).collect(Collectors.toList()));
            }
        }
        if (TransportType.REST.equals((Object)request.getTransportType()) || TransportType.SOAP.equals((Object)request.getTransportType())) {
            response.setEndpoint(((HttpRequestEntitySaveRequest)request).getUrlWithQueryParameters());
        }
        return response;
    }

    public ImportContextResponse importContextVariables(ImportContextRequest request) {
        if (request == null || request.getImportEntityType() == null || request.getImportEntityId() == null) {
            throw new ItfLiteIncorrectImportContextVariablesRequest(new Gson().toJson((Object)request));
        }
        ResponseEntity<List<ContextVariableDto>> contextVariableDtoResponse = null;
        if (request.getImportEntityType().equals((Object)ImportContextRequest.ImportEntityType.EXECUTION_REQUEST)) {
            UUID executionRequestId = request.getImportEntityId();
            ResponseEntity<Map<String, List<TestRunDto>>> testRunsResponse = this.ramExecutionRequestFeignClient.getAllTestRunsBySomeExecutionRequests(executionRequestId.toString());
            if (testRunsResponse.getBody() == null || CollectionUtils.isEmpty((Collection)((Collection)((Map)testRunsResponse.getBody()).get(executionRequestId.toString())))) {
                throw new ItfLiteTestRunsNotFoundException(executionRequestId);
            }
            List testRunDto = (List)((Map)testRunsResponse.getBody()).get(executionRequestId.toString());
            if (testRunDto.size() > 1) {
                throw new ItfLiteIllegalTestRunsCountInExecutionRequestException(executionRequestId);
            }
            contextVariableDtoResponse = this.ramTestRunsFeignClient.getAllContextVariables(((TestRunDto)testRunDto.get(0)).getUuid());
        }
        if (request.getImportEntityType().equals((Object)ImportContextRequest.ImportEntityType.TEST_RUN)) {
            contextVariableDtoResponse = this.ramTestRunsFeignClient.getAllContextVariables(request.getImportEntityId());
        }
        if (request.getImportEntityType().equals((Object)ImportContextRequest.ImportEntityType.LOG_RECORD)) {
            contextVariableDtoResponse = this.ramLogRecordFeignClient.getAllContextVariables(request.getImportEntityId());
        }
        return this.generateImportContextResponse(contextVariableDtoResponse == null ? null : (List)contextVariableDtoResponse.getBody());
    }

    private ImportContextResponse generateImportContextResponse(List<ContextVariableDto> contextVariableDto) {
        List<ContextVariable> contextVariables = CollectionUtils.isEmpty(contextVariableDto) ? Collections.emptyList() : contextVariableDto.stream().map(ContextVariable::new).collect(Collectors.toList());
        return ImportContextResponse.builder().importedVariables(contextVariables).build();
    }

    public List<Cookie> importCookies(ImportFromRamRequest importRequest) {
        if (Objects.isNull(importRequest) || Objects.isNull(importRequest.getExecutionRequestId()) && Objects.isNull(importRequest.getTestRunId()) && Objects.isNull(importRequest.getLogRecordId())) {
            log.error("Invalid import cookie request. All field are null");
            throw new ItfLiteIncorrectImportRequest("At least one of the fields must be specified");
        }
        if (Objects.nonNull(importRequest.getTestRunId())) {
            UUID testRunId = importRequest.getTestRunId();
            UUID logRecordId = importRequest.getLogRecordId();
            return this.parseCookieFromLogRecords(testRunId, logRecordId);
        }
        if (Objects.nonNull(importRequest.getExecutionRequestId())) {
            UUID erId = importRequest.getExecutionRequestId();
            List testRunIds = (List)this.ramExecutionRequestFeignClient.getAllTestRunIds(erId).getBody();
            if (CollectionUtils.isEmpty((Collection)testRunIds)) {
                log.error("The execution request should contain test run, but it is not found");
                throw new ItfLiteTestRunsNotFoundException(erId);
            }
            if (testRunIds.size() > 1) {
                log.error("Execution Request must contain only one test run to import cookies");
                throw new ItfLiteIllegalTestRunsCountInExecutionRequestException(erId);
            }
            return this.parseCookieFromLogRecords((UUID)testRunIds.get(0), null);
        }
        return null;
    }

    private List<Cookie> parseCookieFromLogRecords(UUID testRunId, @Nullable UUID logRecordId) {
        ArrayList<Cookie> importedCookies = new ArrayList<Cookie>();
        LogRecordFilteringRequestDto filter = new LogRecordFilteringRequestDto().addTypesItem(TypeActionDto.TRANSPORT.getValue());
        List logRecords = (List)this.ramTestRunsFeignClient.getAllFilteredLogRecords(testRunId, filter).getBody();
        if (!CollectionUtils.isEmpty((Collection)logRecords)) {
            for (LogRecordDto logRecord : logRecords) {
                if (logRecord instanceof RestLogRecordDto) {
                    RestLogRecordDto restLogRecord = (RestLogRecordDto)logRecord;
                    importedCookies.addAll(this.parseRestLogRecordCookie(restLogRecord));
                }
                if (!logRecord.getUuid().equals(logRecordId)) continue;
                break;
            }
        }
        return importedCookies;
    }

    private List<Cookie> parseRestLogRecordCookie(RestLogRecordDto logRecord) {
        ResponseDto response;
        ArrayList<Cookie> importedCookies = new ArrayList<Cookie>();
        RequestDto request = logRecord.getRequest();
        String domain = "";
        if (StringUtils.isNotEmpty((String)request.getEndpoint())) {
            domain = UrlParsingUtils.getDomain(request.getEndpoint());
        }
        if (!CollectionUtils.isEmpty(request.getHeadersList())) {
            for (RequestHeaderDto header : request.getHeadersList()) {
                String cookieHeaderValue = header.getValue();
                if (!"Cookie".equals(header.getName()) || !StringUtils.isNotEmpty((String)cookieHeaderValue)) continue;
                importedCookies.addAll(CookieUtils.parseCookieHeader(domain, cookieHeaderValue));
            }
        }
        if (Objects.nonNull(response = logRecord.getResponse()) && !CollectionUtils.isEmpty(response.getHeadersList())) {
            for (RequestHeaderDto header : response.getHeadersList()) {
                String cookieHeaderValue = header.getValue();
                if (!"Set-Cookie".equals(header.getName()) || !StringUtils.isNotEmpty((String)cookieHeaderValue)) continue;
                importedCookies.addAll(CookieUtils.parseCookieHeader(domain, cookieHeaderValue));
            }
        }
        return importedCookies;
    }

    public void closeCurrentSection(Map<String, Object> oldContext, Map<String, Object> newContext) {
        AtpRamWriter writer = AtpRamWriter.getAtpRamWriter();
        List<org.qubership.atp.ram.models.logrecords.parts.ContextVariable> contextVariables = this.getContextVariables(oldContext, newContext);
        writer.getAdapter().updateContextVariables(writer.getContext().getCurrentSectionId(), contextVariables);
        writer.closeSection();
    }

    public void openNewExecuteRequestSection(String requestName, Long createdDateStamp) {
        Message msg = new Message();
        msg.setType(TypeAction.ITF.name());
        msg.setName(String.format("Execute request \"%s\"", requestName));
        msg.setExecutionStatus(ExecutionStatuses.IN_PROGRESS.name());
        msg.setCreatedDateStamp(createdDateStamp);
        AtpRamWriter writer = AtpRamWriter.getAtpRamWriter();
        writer.writeParentSections(writer.getContext().getAtpCompaund().getParentSection());
        writer.getAdapter().openItfSection(msg, null);
    }

    public void writeMessage(String message, TestingStatuses status) {
        AtpRamWriter.getAtpRamWriter().updateMessageTestingStatusAndFiles(message, status, null);
    }

    public void updateExecutionStatus(ExecutionCollectionRequestExecuteRequest requestExecuteRequest, ExecutionStatuses status) {
        Timestamp startDate = Objects.nonNull(requestExecuteRequest.getSection().getStartDate()) ? requestExecuteRequest.getSection().getStartDate() : new Timestamp(new Date().getTime());
        AtpRamWriter.getAtpRamWriter().getAdapter().updateExecutionStatus(requestExecuteRequest.getSection().getSectionId(), status.name(), startDate, new Date().getTime() - startDate.getTime());
    }

    public void updateTestingStatus(TestingStatuses testStatus) {
        AtpRamWriter writer = AtpRamWriter.getAtpRamWriter();
        writer.getAdapter().updateTestingStatus(writer.getContext().getCurrentSectionId(), testStatus.name());
    }

    public RamService(RamTestPlansFeignClient testPlansFeignClient, RamTestRunsFeignClient ramTestRunsFeignClient, RamLogRecordFeignClient ramLogRecordFeignClient, RamExecutionRequestFeignClient ramExecutionRequestFeignClient, GridFsService gridFsService, String fileDownloadLink) {
        this.testPlansFeignClient = testPlansFeignClient;
        this.ramTestRunsFeignClient = ramTestRunsFeignClient;
        this.ramLogRecordFeignClient = ramLogRecordFeignClient;
        this.ramExecutionRequestFeignClient = ramExecutionRequestFeignClient;
        this.gridFsService = gridFsService;
        this.fileDownloadLink = fileDownloadLink;
    }
}

