/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.interceptors;

import feign.RequestTemplate;
import java.io.IOException;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.protocol.HttpContext;
import org.qubership.atp.auth.springbootstarter.security.oauth2.client.config.Oauth2FeignClientInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ItfLiteHttpRequestInterceptor
implements HttpRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ItfLiteHttpRequestInterceptor.class);
    private final Oauth2FeignClientInterceptor oauth2FeignClientInterceptor;

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        log.info("process [request={}, context={}]", (Object)request, (Object)context);
        Optional<String> token = this.getAuthorizationToken();
        if (token.isPresent()) {
            log.info("Set authorization token");
            request.addHeader("Authorization", token.get());
            return;
        }
        log.warn("Token in context is empty");
    }

    private Optional<String> getAuthorizationToken() {
        RequestTemplate requestTemplate = new RequestTemplate();
        this.oauth2FeignClientInterceptor.apply(requestTemplate);
        Collection headers = (Collection)requestTemplate.headers().get("Authorization");
        if (Objects.nonNull(headers)) {
            return headers.size() < 2 ? headers.stream().findFirst() : headers.stream().filter(header -> header.startsWith("Bearer")).findFirst();
        }
        return Optional.empty();
    }

    public ItfLiteHttpRequestInterceptor(Oauth2FeignClientInterceptor oauth2FeignClientInterceptor) {
        this.oauth2FeignClientInterceptor = oauth2FeignClientInterceptor;
    }
}

