/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.api.kafka.entities;

import java.util.HashMap;
import java.util.Map;
import org.qubership.atp.itf.lite.backend.enums.http.RequestBodyType;
import org.qubership.atp.itf.lite.backend.model.api.kafka.entities.ExportRequestEntity;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;

public class HttpRequestExportEntity
extends ExportRequestEntity {
    private HttpMethod httpMethod;
    private String url;
    private Map<String, String> queryParameters;
    private Map<String, String> requestHeaders;
    private RequestBody body;

    public HttpRequestExportEntity(HttpRequest request) {
        this.commonProcessing(request);
        this.setBody(request.getBody());
    }

    public HttpRequestExportEntity(HttpRequest request, boolean simplify) {
        this.commonProcessing(request);
        if (simplify && request.getBody() != null && RequestBodyType.GraphQL.equals((Object)request.getBody().getType())) {
            RequestBody simplifiedBody = new RequestBody();
            simplifiedBody.setContent(request.getBody().computeAndGetContent());
            simplifiedBody.setType(RequestBodyType.JSON);
            this.setBody(simplifiedBody);
        } else {
            this.setBody(request.getBody());
        }
    }

    private void commonProcessing(HttpRequest request) {
        this.setId(request.getId());
        this.setName(request.getName());
        this.setTransportType(request.getTransportType());
        this.setHttpMethod(request.getHttpMethod());
        this.setUrl(request.getUrl());
        this.setBody(request.getBody());
        if (!request.getRequestParams().isEmpty()) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            request.getRequestParams().forEach(param -> {
                if (parameters.containsKey(param.getKey())) {
                    String value = (String)parameters.get(param.getKey());
                    parameters.put(param.getKey(), value + "," + param.getValue());
                } else {
                    parameters.put(param.getKey(), param.getValue());
                }
            });
            this.setQueryParameters(parameters);
        }
        if (!request.getRequestHeaders().isEmpty()) {
            HashMap<String, String> headers = new HashMap<String, String>();
            request.getRequestHeaders().forEach(header -> {
                if (headers.containsKey(header.getKey())) {
                    String value = (String)headers.get(header.getKey());
                    headers.put(header.getKey(), value + ";" + header.getValue());
                } else {
                    headers.put(header.getKey(), header.getValue());
                }
            });
            this.setRequestHeaders(headers);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequestExportEntity)) {
            return false;
        }
        HttpRequestExportEntity other = (HttpRequestExportEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !((Object)((Object)this$httpMethod)).equals((Object)other$httpMethod)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        Map<String, String> this$queryParameters = this.getQueryParameters();
        Map<String, String> other$queryParameters = other.getQueryParameters();
        if (this$queryParameters == null ? other$queryParameters != null : !((Object)this$queryParameters).equals(other$queryParameters)) {
            return false;
        }
        Map<String, String> this$requestHeaders = this.getRequestHeaders();
        Map<String, String> other$requestHeaders = other.getRequestHeaders();
        if (this$requestHeaders == null ? other$requestHeaders != null : !((Object)this$requestHeaders).equals(other$requestHeaders)) {
            return false;
        }
        RequestBody this$body = this.getBody();
        RequestBody other$body = other.getBody();
        return !(this$body == null ? other$body != null : !((Object)this$body).equals(other$body));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequestExportEntity;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : ((Object)((Object)$httpMethod)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        Map<String, String> $queryParameters = this.getQueryParameters();
        result = result * 59 + ($queryParameters == null ? 43 : ((Object)$queryParameters).hashCode());
        Map<String, String> $requestHeaders = this.getRequestHeaders();
        result = result * 59 + ($requestHeaders == null ? 43 : ((Object)$requestHeaders).hashCode());
        RequestBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        return result;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, String> getQueryParameters() {
        return this.queryParameters;
    }

    public Map<String, String> getRequestHeaders() {
        return this.requestHeaders;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setQueryParameters(Map<String, String> queryParameters) {
        this.queryParameters = queryParameters;
    }

    public void setRequestHeaders(Map<String, String> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setBody(RequestBody body) {
        this.body = body;
    }

    @Override
    public String toString() {
        return "HttpRequestExportEntity(httpMethod=" + (Object)((Object)this.getHttpMethod()) + ", url=" + this.getUrl() + ", queryParameters=" + this.getQueryParameters() + ", requestHeaders=" + this.getRequestHeaders() + ", body=" + this.getBody() + ")";
    }

    public HttpRequestExportEntity(HttpMethod httpMethod, String url, Map<String, String> queryParameters, Map<String, String> requestHeaders, RequestBody body) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.queryParameters = queryParameters;
        this.requestHeaders = requestHeaders;
        this.body = body;
    }

    public HttpRequestExportEntity() {
    }
}

