/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.api.request;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.constraints.NotNull;
import org.qubership.atp.itf.lite.backend.catalog.models.Flags;
import org.qubership.atp.itf.lite.backend.catalog.models.FlagsDeserializer;
import org.qubership.atp.itf.lite.backend.model.api.request.ContextVariable;
import org.qubership.atp.itf.lite.backend.model.api.response.GroupResponse;
import org.springframework.util.CollectionUtils;

@JsonIgnoreProperties(ignoreUnknown=true)
public class CollectionExecuteRequest {
    private String name;
    private List<GroupResponse> treeNodes;
    @NotNull
    private List<UUID> environmentIds;
    private List<String> emailRecipients;
    private UUID emailTemplateId;
    private String emailSubject;
    @NotNull
    private List<UUID> taToolIds;
    @JsonDeserialize(using=FlagsDeserializer.class)
    private List<Flags> flags;
    private UUID logCollectorTemplateId;
    private UUID projectId;
    private UUID testPlanId;
    private boolean isMandatoryCheck;
    private boolean isSsmCheck;
    private boolean isIgnoreFailedChecks;
    private int threadCount;
    private UUID dataSetStorageId;
    private UUID dataSetId;
    private List<ContextVariable> contextVariables;
    private boolean propagateCookies;

    public Map<String, Object> convertContextVariablesToMap() {
        if (!CollectionUtils.isEmpty(this.contextVariables)) {
            return this.contextVariables.stream().collect(Collectors.toMap(variable -> variable.getContextVariableType().getContextScope().getPrefix() + variable.getKey(), ContextVariable::getValue));
        }
        return new HashMap<String, Object>();
    }

    public String getName() {
        return this.name;
    }

    public List<GroupResponse> getTreeNodes() {
        return this.treeNodes;
    }

    public List<UUID> getEnvironmentIds() {
        return this.environmentIds;
    }

    public List<String> getEmailRecipients() {
        return this.emailRecipients;
    }

    public UUID getEmailTemplateId() {
        return this.emailTemplateId;
    }

    public String getEmailSubject() {
        return this.emailSubject;
    }

    public List<UUID> getTaToolIds() {
        return this.taToolIds;
    }

    public List<Flags> getFlags() {
        return this.flags;
    }

    public UUID getLogCollectorTemplateId() {
        return this.logCollectorTemplateId;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public UUID getTestPlanId() {
        return this.testPlanId;
    }

    public boolean isMandatoryCheck() {
        return this.isMandatoryCheck;
    }

    public boolean isSsmCheck() {
        return this.isSsmCheck;
    }

    public boolean isIgnoreFailedChecks() {
        return this.isIgnoreFailedChecks;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public UUID getDataSetStorageId() {
        return this.dataSetStorageId;
    }

    public UUID getDataSetId() {
        return this.dataSetId;
    }

    public List<ContextVariable> getContextVariables() {
        return this.contextVariables;
    }

    public boolean isPropagateCookies() {
        return this.propagateCookies;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTreeNodes(List<GroupResponse> treeNodes) {
        this.treeNodes = treeNodes;
    }

    public void setEnvironmentIds(List<UUID> environmentIds) {
        this.environmentIds = environmentIds;
    }

    public void setEmailRecipients(List<String> emailRecipients) {
        this.emailRecipients = emailRecipients;
    }

    public void setEmailTemplateId(UUID emailTemplateId) {
        this.emailTemplateId = emailTemplateId;
    }

    public void setEmailSubject(String emailSubject) {
        this.emailSubject = emailSubject;
    }

    public void setTaToolIds(List<UUID> taToolIds) {
        this.taToolIds = taToolIds;
    }

    @JsonDeserialize(using=FlagsDeserializer.class)
    public void setFlags(List<Flags> flags) {
        this.flags = flags;
    }

    public void setLogCollectorTemplateId(UUID logCollectorTemplateId) {
        this.logCollectorTemplateId = logCollectorTemplateId;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setTestPlanId(UUID testPlanId) {
        this.testPlanId = testPlanId;
    }

    public void setMandatoryCheck(boolean isMandatoryCheck) {
        this.isMandatoryCheck = isMandatoryCheck;
    }

    public void setSsmCheck(boolean isSsmCheck) {
        this.isSsmCheck = isSsmCheck;
    }

    public void setIgnoreFailedChecks(boolean isIgnoreFailedChecks) {
        this.isIgnoreFailedChecks = isIgnoreFailedChecks;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public void setDataSetStorageId(UUID dataSetStorageId) {
        this.dataSetStorageId = dataSetStorageId;
    }

    public void setDataSetId(UUID dataSetId) {
        this.dataSetId = dataSetId;
    }

    public void setContextVariables(List<ContextVariable> contextVariables) {
        this.contextVariables = contextVariables;
    }

    public void setPropagateCookies(boolean propagateCookies) {
        this.propagateCookies = propagateCookies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CollectionExecuteRequest)) {
            return false;
        }
        CollectionExecuteRequest other = (CollectionExecuteRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isMandatoryCheck() != other.isMandatoryCheck()) {
            return false;
        }
        if (this.isSsmCheck() != other.isSsmCheck()) {
            return false;
        }
        if (this.isIgnoreFailedChecks() != other.isIgnoreFailedChecks()) {
            return false;
        }
        if (this.getThreadCount() != other.getThreadCount()) {
            return false;
        }
        if (this.isPropagateCookies() != other.isPropagateCookies()) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        List<GroupResponse> this$treeNodes = this.getTreeNodes();
        List<GroupResponse> other$treeNodes = other.getTreeNodes();
        if (this$treeNodes == null ? other$treeNodes != null : !((Object)this$treeNodes).equals(other$treeNodes)) {
            return false;
        }
        List<UUID> this$environmentIds = this.getEnvironmentIds();
        List<UUID> other$environmentIds = other.getEnvironmentIds();
        if (this$environmentIds == null ? other$environmentIds != null : !((Object)this$environmentIds).equals(other$environmentIds)) {
            return false;
        }
        List<String> this$emailRecipients = this.getEmailRecipients();
        List<String> other$emailRecipients = other.getEmailRecipients();
        if (this$emailRecipients == null ? other$emailRecipients != null : !((Object)this$emailRecipients).equals(other$emailRecipients)) {
            return false;
        }
        UUID this$emailTemplateId = this.getEmailTemplateId();
        UUID other$emailTemplateId = other.getEmailTemplateId();
        if (this$emailTemplateId == null ? other$emailTemplateId != null : !((Object)this$emailTemplateId).equals(other$emailTemplateId)) {
            return false;
        }
        String this$emailSubject = this.getEmailSubject();
        String other$emailSubject = other.getEmailSubject();
        if (this$emailSubject == null ? other$emailSubject != null : !this$emailSubject.equals(other$emailSubject)) {
            return false;
        }
        List<UUID> this$taToolIds = this.getTaToolIds();
        List<UUID> other$taToolIds = other.getTaToolIds();
        if (this$taToolIds == null ? other$taToolIds != null : !((Object)this$taToolIds).equals(other$taToolIds)) {
            return false;
        }
        List<Flags> this$flags = this.getFlags();
        List<Flags> other$flags = other.getFlags();
        if (this$flags == null ? other$flags != null : !((Object)this$flags).equals(other$flags)) {
            return false;
        }
        UUID this$logCollectorTemplateId = this.getLogCollectorTemplateId();
        UUID other$logCollectorTemplateId = other.getLogCollectorTemplateId();
        if (this$logCollectorTemplateId == null ? other$logCollectorTemplateId != null : !((Object)this$logCollectorTemplateId).equals(other$logCollectorTemplateId)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        UUID this$testPlanId = this.getTestPlanId();
        UUID other$testPlanId = other.getTestPlanId();
        if (this$testPlanId == null ? other$testPlanId != null : !((Object)this$testPlanId).equals(other$testPlanId)) {
            return false;
        }
        UUID this$dataSetStorageId = this.getDataSetStorageId();
        UUID other$dataSetStorageId = other.getDataSetStorageId();
        if (this$dataSetStorageId == null ? other$dataSetStorageId != null : !((Object)this$dataSetStorageId).equals(other$dataSetStorageId)) {
            return false;
        }
        UUID this$dataSetId = this.getDataSetId();
        UUID other$dataSetId = other.getDataSetId();
        if (this$dataSetId == null ? other$dataSetId != null : !((Object)this$dataSetId).equals(other$dataSetId)) {
            return false;
        }
        List<ContextVariable> this$contextVariables = this.getContextVariables();
        List<ContextVariable> other$contextVariables = other.getContextVariables();
        return !(this$contextVariables == null ? other$contextVariables != null : !((Object)this$contextVariables).equals(other$contextVariables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CollectionExecuteRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isMandatoryCheck() ? 79 : 97);
        result = result * 59 + (this.isSsmCheck() ? 79 : 97);
        result = result * 59 + (this.isIgnoreFailedChecks() ? 79 : 97);
        result = result * 59 + this.getThreadCount();
        result = result * 59 + (this.isPropagateCookies() ? 79 : 97);
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        List<GroupResponse> $treeNodes = this.getTreeNodes();
        result = result * 59 + ($treeNodes == null ? 43 : ((Object)$treeNodes).hashCode());
        List<UUID> $environmentIds = this.getEnvironmentIds();
        result = result * 59 + ($environmentIds == null ? 43 : ((Object)$environmentIds).hashCode());
        List<String> $emailRecipients = this.getEmailRecipients();
        result = result * 59 + ($emailRecipients == null ? 43 : ((Object)$emailRecipients).hashCode());
        UUID $emailTemplateId = this.getEmailTemplateId();
        result = result * 59 + ($emailTemplateId == null ? 43 : ((Object)$emailTemplateId).hashCode());
        String $emailSubject = this.getEmailSubject();
        result = result * 59 + ($emailSubject == null ? 43 : $emailSubject.hashCode());
        List<UUID> $taToolIds = this.getTaToolIds();
        result = result * 59 + ($taToolIds == null ? 43 : ((Object)$taToolIds).hashCode());
        List<Flags> $flags = this.getFlags();
        result = result * 59 + ($flags == null ? 43 : ((Object)$flags).hashCode());
        UUID $logCollectorTemplateId = this.getLogCollectorTemplateId();
        result = result * 59 + ($logCollectorTemplateId == null ? 43 : ((Object)$logCollectorTemplateId).hashCode());
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        UUID $testPlanId = this.getTestPlanId();
        result = result * 59 + ($testPlanId == null ? 43 : ((Object)$testPlanId).hashCode());
        UUID $dataSetStorageId = this.getDataSetStorageId();
        result = result * 59 + ($dataSetStorageId == null ? 43 : ((Object)$dataSetStorageId).hashCode());
        UUID $dataSetId = this.getDataSetId();
        result = result * 59 + ($dataSetId == null ? 43 : ((Object)$dataSetId).hashCode());
        List<ContextVariable> $contextVariables = this.getContextVariables();
        result = result * 59 + ($contextVariables == null ? 43 : ((Object)$contextVariables).hashCode());
        return result;
    }

    public String toString() {
        return "CollectionExecuteRequest(name=" + this.getName() + ", treeNodes=" + this.getTreeNodes() + ", environmentIds=" + this.getEnvironmentIds() + ", emailRecipients=" + this.getEmailRecipients() + ", emailTemplateId=" + this.getEmailTemplateId() + ", emailSubject=" + this.getEmailSubject() + ", taToolIds=" + this.getTaToolIds() + ", flags=" + this.getFlags() + ", logCollectorTemplateId=" + this.getLogCollectorTemplateId() + ", projectId=" + this.getProjectId() + ", testPlanId=" + this.getTestPlanId() + ", isMandatoryCheck=" + this.isMandatoryCheck() + ", isSsmCheck=" + this.isSsmCheck() + ", isIgnoreFailedChecks=" + this.isIgnoreFailedChecks() + ", threadCount=" + this.getThreadCount() + ", dataSetStorageId=" + this.getDataSetStorageId() + ", dataSetId=" + this.getDataSetId() + ", contextVariables=" + this.getContextVariables() + ", propagateCookies=" + this.isPropagateCookies() + ")";
    }
}

