/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.api.request;

import java.io.Serializable;
import org.qubership.atp.itf.lite.backend.annotations.SerializableCheckable;
import org.qubership.atp.itf.lite.backend.enums.ContextVariableType;
import org.qubership.atp.itf.lite.backend.feign.dto.ContextVariableDto;
import org.springframework.util.StringUtils;

@SerializableCheckable
public class ContextVariable
implements Serializable {
    private String key;
    private Object value;
    private final ContextVariableType contextVariableType;

    public ContextVariable() {
        this.contextVariableType = ContextVariableType.GLOBAL;
    }

    public ContextVariable(ContextVariableDto contextVariableDto) {
        this.key = contextVariableDto.getName();
        this.value = StringUtils.isEmpty((Object)contextVariableDto.getAfterValue()) ? contextVariableDto.getBeforeValue() : contextVariableDto.getAfterValue();
        this.contextVariableType = ContextVariableType.fromContextVariableKey(contextVariableDto.getName());
    }

    public String getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public ContextVariableType getContextVariableType() {
        return this.contextVariableType;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextVariable)) {
            return false;
        }
        ContextVariable other = (ContextVariable)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$key = this.getKey();
        String other$key = other.getKey();
        if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
            return false;
        }
        Object this$value = this.getValue();
        Object other$value = other.getValue();
        if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
            return false;
        }
        ContextVariableType this$contextVariableType = this.getContextVariableType();
        ContextVariableType other$contextVariableType = other.getContextVariableType();
        return !(this$contextVariableType == null ? other$contextVariableType != null : !((Object)((Object)this$contextVariableType)).equals((Object)other$contextVariableType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ContextVariable;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $key = this.getKey();
        result = result * 59 + ($key == null ? 43 : $key.hashCode());
        Object $value = this.getValue();
        result = result * 59 + ($value == null ? 43 : $value.hashCode());
        ContextVariableType $contextVariableType = this.getContextVariableType();
        result = result * 59 + ($contextVariableType == null ? 43 : ((Object)((Object)$contextVariableType)).hashCode());
        return result;
    }

    public String toString() {
        return "ContextVariable(key=" + this.getKey() + ", value=" + this.getValue() + ", contextVariableType=" + (Object)((Object)this.getContextVariableType()) + ")";
    }

    public ContextVariable(String key, Object value, ContextVariableType contextVariableType) {
        this.key = key;
        this.value = value;
        this.contextVariableType = contextVariableType;
    }
}

