/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.api.request;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.itf.lite.backend.feign.dto.HeaderDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanPostmanRequestDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanUrlDto;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpParamSaveRequest;
import org.qubership.atp.itf.lite.backend.model.entities.Cookie;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileData;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.util.UriComponentsBuilder;

public class HttpRequestEntitySaveRequest
extends RequestEntitySaveRequest {
    @NotNull
    private HttpMethod httpMethod;
    @NotEmpty
    private String url;
    private List<HttpParamSaveRequest> requestParams;
    private List<HttpHeaderSaveRequest> requestHeaders;
    private RequestBody body;
    private FileData file;
    private List<Cookie> cookies;

    @Override
    public void resolveTemplates(Function<String, String> evaluateFunction) {
        this.url = evaluateFunction.apply(this.url);
        if (Objects.nonNull(this.requestParams)) {
            this.requestParams.forEach(p -> {
                p.setKey((String)evaluateFunction.apply(p.getKey()));
                p.setValue((String)evaluateFunction.apply(p.getValue()));
            });
        }
        if (Objects.nonNull(this.requestHeaders)) {
            this.requestHeaders.forEach(h -> {
                h.setKey((String)evaluateFunction.apply(h.getKey()));
                h.setValue((String)evaluateFunction.apply(h.getValue()));
            });
        }
        if (!Objects.isNull(this.body) && !StringUtils.isEmpty((Object)this.body.getContent())) {
            this.body.setContent(evaluateFunction.apply(this.body.getContent()));
        }
    }

    public String getUrlWithQueryParameters() {
        UriComponentsBuilder uriComponentsBuilder = UriComponentsBuilder.newInstance();
        if (!CollectionUtils.isEmpty(this.requestParams)) {
            this.requestParams.forEach(parameter -> {
                if (!parameter.isDisabled()) {
                    uriComponentsBuilder.queryParam(parameter.getKey(), new Object[]{parameter.getValue()});
                }
            });
        }
        return this.url + uriComponentsBuilder.build().toUri();
    }

    @Override
    public void normalize() {
        this.url = StringUtils.isEmpty((Object)this.url) ? this.url : this.url.trim();
    }

    @Override
    @JsonIgnore
    public PostmanPostmanRequestDto getPostmanRequest() {
        PostmanPostmanRequestDto pmRequest = new PostmanPostmanRequestDto();
        pmRequest.setId(this.getId());
        pmRequest.setName(this.getName());
        pmRequest.setMethod(this.getHttpMethod().toString());
        if (Objects.nonNull(this.getRequestParams())) {
            pmRequest.setUrl(this.generatePostmanUrlDto(this.getUrl(), this.getRequestParams()));
        } else {
            pmRequest.setUrl(this.generatePostmanUrlDto(this.getUrl(), null));
        }
        if (Objects.nonNull(this.getRequestHeaders())) {
            pmRequest.setHeader(this.getRequestHeaders().stream().filter(header -> !header.isDisabled()).map(h -> new HeaderDto().key(h.getKey()).value(h.getValue())).collect(Collectors.toList()));
        }
        if (Objects.nonNull(this.getBody())) {
            pmRequest.setBody(this.getBody().getPostmanBody(this.getFile()));
        }
        return pmRequest;
    }

    @Override
    public void updateFromPostmanRequest(PostmanPostmanRequestDto postmanRequest) {
        this.setHttpMethod(HttpMethod.resolve(postmanRequest.getMethod()));
        this.setUrl(this.urlWithoutQuery(postmanRequest.getUrl()));
        if (Objects.nonNull(postmanRequest.getUrl().getQuery())) {
            this.setRequestParams(postmanRequest.getUrl().getQuery().stream().map(q -> new HttpParamSaveRequest(q.getKey(), (String)q.getValue(), "")).collect(Collectors.toList()));
        }
        if (Objects.nonNull(postmanRequest.getHeader())) {
            this.setRequestHeaders(postmanRequest.getHeader().stream().map(h -> new HttpHeaderSaveRequest(h.getKey(), (String)h.getValue(), "")).collect(Collectors.toList()));
        }
        if (Objects.nonNull(postmanRequest.getBody())) {
            if (Objects.isNull(this.getBody())) {
                this.setBody(new RequestBody());
            }
            this.getBody().updateFromPostmanBody(postmanRequest.getBody());
        }
    }

    private PostmanUrlDto generatePostmanUrlDto(String url, List<HttpParamSaveRequest> queryParams) {
        PostmanUrlDto postmanUrlDto = new PostmanUrlDto();
        try {
            URL tmpUrl = new URL(url);
            postmanUrlDto.protocol(tmpUrl.getProtocol()).host(Collections.singletonList(tmpUrl.getHost())).port(tmpUrl.getPort() != -1 ? String.valueOf(tmpUrl.getPort()) : null).path(Collections.singletonList(tmpUrl.getPath())).query(this.parseQuery(tmpUrl.getQuery()));
        }
        catch (MalformedURLException ignore) {
            postmanUrlDto.host(Collections.singletonList(url)).query(new ArrayList<HeaderDto>());
        }
        if (queryParams != null) {
            List<HeaderDto> queryParameters = queryParams.stream().filter(q -> !q.isDisabled()).map(q -> new HeaderDto().key(q.getKey()).value(q.getValue())).collect(Collectors.toList());
            if (postmanUrlDto.getQuery() == null) {
                postmanUrlDto.setQuery(queryParameters);
            } else {
                postmanUrlDto.getQuery().addAll(queryParameters);
            }
        }
        return postmanUrlDto;
    }

    private List<HeaderDto> parseQuery(String query) {
        String[] queryParams;
        ArrayList<HeaderDto> queryParameters = new ArrayList<HeaderDto>();
        if (Strings.isEmpty((CharSequence)query)) {
            return queryParameters;
        }
        for (String queryParam : queryParams = query.split("&")) {
            String[] kv = queryParam.split("=");
            String key = kv[0];
            if (kv.length == 2) {
                queryParameters.add(new HeaderDto().key(key).value(kv[1]));
                continue;
            }
            queryParameters.add(new HeaderDto().key(key).value(null));
        }
        return queryParameters;
    }

    private String urlWithoutQuery(PostmanUrlDto postmanUrlDto) {
        StringBuilder sb = new StringBuilder();
        if (Objects.nonNull(postmanUrlDto.getProtocol())) {
            sb.append(postmanUrlDto.getProtocol()).append("://");
        }
        sb.append(String.join((CharSequence)".", postmanUrlDto.getHost()));
        if (Objects.nonNull(postmanUrlDto.getPort())) {
            sb.append(":").append(postmanUrlDto.getPort());
        }
        sb.append(this.getPostmanUrlPath(postmanUrlDto));
        return sb.toString();
    }

    public String getPostmanUrlPath(PostmanUrlDto postmanUrlDto) {
        if (Objects.isNull(postmanUrlDto.getPath())) {
            return "";
        }
        return String.join((CharSequence)"/", postmanUrlDto.getPath());
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequestEntitySaveRequest)) {
            return false;
        }
        HttpRequestEntitySaveRequest other = (HttpRequestEntitySaveRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !((Object)((Object)this$httpMethod)).equals((Object)other$httpMethod)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<HttpParamSaveRequest> this$requestParams = this.getRequestParams();
        List<HttpParamSaveRequest> other$requestParams = other.getRequestParams();
        if (this$requestParams == null ? other$requestParams != null : !((Object)this$requestParams).equals(other$requestParams)) {
            return false;
        }
        List<HttpHeaderSaveRequest> this$requestHeaders = this.getRequestHeaders();
        List<HttpHeaderSaveRequest> other$requestHeaders = other.getRequestHeaders();
        if (this$requestHeaders == null ? other$requestHeaders != null : !((Object)this$requestHeaders).equals(other$requestHeaders)) {
            return false;
        }
        RequestBody this$body = this.getBody();
        RequestBody other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        FileData this$file = this.getFile();
        FileData other$file = other.getFile();
        if (this$file == null ? other$file != null : !((Object)this$file).equals(other$file)) {
            return false;
        }
        List<Cookie> this$cookies = this.getCookies();
        List<Cookie> other$cookies = other.getCookies();
        return !(this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequestEntitySaveRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : ((Object)((Object)$httpMethod)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<HttpParamSaveRequest> $requestParams = this.getRequestParams();
        result = result * 59 + ($requestParams == null ? 43 : ((Object)$requestParams).hashCode());
        List<HttpHeaderSaveRequest> $requestHeaders = this.getRequestHeaders();
        result = result * 59 + ($requestHeaders == null ? 43 : ((Object)$requestHeaders).hashCode());
        RequestBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        FileData $file = this.getFile();
        result = result * 59 + ($file == null ? 43 : ((Object)$file).hashCode());
        List<Cookie> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        return result;
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public List<HttpParamSaveRequest> getRequestParams() {
        return this.requestParams;
    }

    public List<HttpHeaderSaveRequest> getRequestHeaders() {
        return this.requestHeaders;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public FileData getFile() {
        return this.file;
    }

    @Override
    public List<Cookie> getCookies() {
        return this.cookies;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setRequestParams(List<HttpParamSaveRequest> requestParams) {
        this.requestParams = requestParams;
    }

    public void setRequestHeaders(List<HttpHeaderSaveRequest> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setBody(RequestBody body) {
        this.body = body;
    }

    public void setFile(FileData file) {
        this.file = file;
    }

    @Override
    public void setCookies(List<Cookie> cookies) {
        this.cookies = cookies;
    }

    @Override
    public String toString() {
        return "HttpRequestEntitySaveRequest(httpMethod=" + (Object)((Object)this.getHttpMethod()) + ", url=" + this.getUrl() + ", requestParams=" + this.getRequestParams() + ", requestHeaders=" + this.getRequestHeaders() + ", body=" + this.getBody() + ", file=" + this.getFile() + ", cookies=" + this.getCookies() + ")";
    }

    public HttpRequestEntitySaveRequest(HttpMethod httpMethod, String url, List<HttpParamSaveRequest> requestParams, List<HttpHeaderSaveRequest> requestHeaders, RequestBody body, FileData file, List<Cookie> cookies) {
        this.httpMethod = httpMethod;
        this.url = url;
        this.requestParams = requestParams;
        this.requestHeaders = requestHeaders;
        this.body = body;
        this.file = file;
        this.cookies = cookies;
    }

    public HttpRequestEntitySaveRequest() {
    }
}

