/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.api.request.auth;

import java.util.function.Function;
import javax.validation.constraints.NotNull;
import org.qubership.atp.itf.lite.backend.enums.auth.OAuth1AddDataType;
import org.qubership.atp.itf.lite.backend.enums.auth.OAuth1SignatureMethod;
import org.qubership.atp.itf.lite.backend.model.api.request.auth.AuthorizationSaveRequest;
import org.qubership.atp.itf.lite.backend.model.entities.auth.OAuth1RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;

public class OAuth1AuthorizationSaveRequest
extends AuthorizationSaveRequest {
    @NotNull
    private String url;
    @NotNull
    private String httpMethod;
    @NotNull
    private OAuth1SignatureMethod signatureMethod;
    @NotNull
    private String consumerKey;
    @NotNull
    private String consumerSecret;
    private String accessToken;
    private String tokenSecret;
    private OAuth1AddDataType addDataType = OAuth1AddDataType.REQUEST_HEADERS;

    @Override
    public Class<? extends RequestAuthorization> getAuthEntityType() {
        return OAuth1RequestAuthorization.class;
    }

    @Override
    public void resolveTemplates(Function<String, String> evaluateFunction) {
        this.consumerKey = evaluateFunction.apply(this.consumerKey);
        this.consumerSecret = evaluateFunction.apply(this.consumerSecret);
        this.accessToken = evaluateFunction.apply(this.accessToken);
        this.tokenSecret = evaluateFunction.apply(this.tokenSecret);
    }

    public String getUrl() {
        return this.url;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public OAuth1SignatureMethod getSignatureMethod() {
        return this.signatureMethod;
    }

    public String getConsumerKey() {
        return this.consumerKey;
    }

    public String getConsumerSecret() {
        return this.consumerSecret;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenSecret() {
        return this.tokenSecret;
    }

    public OAuth1AddDataType getAddDataType() {
        return this.addDataType;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setSignatureMethod(OAuth1SignatureMethod signatureMethod) {
        this.signatureMethod = signatureMethod;
    }

    public void setConsumerKey(String consumerKey) {
        this.consumerKey = consumerKey;
    }

    public void setConsumerSecret(String consumerSecret) {
        this.consumerSecret = consumerSecret;
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    public void setTokenSecret(String tokenSecret) {
        this.tokenSecret = tokenSecret;
    }

    public void setAddDataType(OAuth1AddDataType addDataType) {
        this.addDataType = addDataType;
    }

    @Override
    public String toString() {
        return "OAuth1AuthorizationSaveRequest(url=" + this.getUrl() + ", httpMethod=" + this.getHttpMethod() + ", signatureMethod=" + (Object)((Object)this.getSignatureMethod()) + ", consumerKey=" + this.getConsumerKey() + ", consumerSecret=" + this.getConsumerSecret() + ", accessToken=" + this.getAccessToken() + ", tokenSecret=" + this.getTokenSecret() + ", addDataType=" + (Object)((Object)this.getAddDataType()) + ")";
    }

    public OAuth1AuthorizationSaveRequest(String url, String httpMethod, OAuth1SignatureMethod signatureMethod, String consumerKey, String consumerSecret, String accessToken, String tokenSecret, OAuth1AddDataType addDataType) {
        this.url = url;
        this.httpMethod = httpMethod;
        this.signatureMethod = signatureMethod;
        this.consumerKey = consumerKey;
        this.consumerSecret = consumerSecret;
        this.accessToken = accessToken;
        this.tokenSecret = tokenSecret;
        this.addDataType = addDataType;
    }

    public OAuth1AuthorizationSaveRequest() {
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof OAuth1AuthorizationSaveRequest)) {
            return false;
        }
        OAuth1AuthorizationSaveRequest other = (OAuth1AuthorizationSaveRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$httpMethod = this.getHttpMethod();
        String other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !this$httpMethod.equals(other$httpMethod)) {
            return false;
        }
        OAuth1SignatureMethod this$signatureMethod = this.getSignatureMethod();
        OAuth1SignatureMethod other$signatureMethod = other.getSignatureMethod();
        if (this$signatureMethod == null ? other$signatureMethod != null : !((Object)((Object)this$signatureMethod)).equals((Object)other$signatureMethod)) {
            return false;
        }
        String this$consumerKey = this.getConsumerKey();
        String other$consumerKey = other.getConsumerKey();
        if (this$consumerKey == null ? other$consumerKey != null : !this$consumerKey.equals(other$consumerKey)) {
            return false;
        }
        String this$consumerSecret = this.getConsumerSecret();
        String other$consumerSecret = other.getConsumerSecret();
        if (this$consumerSecret == null ? other$consumerSecret != null : !this$consumerSecret.equals(other$consumerSecret)) {
            return false;
        }
        String this$accessToken = this.getAccessToken();
        String other$accessToken = other.getAccessToken();
        if (this$accessToken == null ? other$accessToken != null : !this$accessToken.equals(other$accessToken)) {
            return false;
        }
        String this$tokenSecret = this.getTokenSecret();
        String other$tokenSecret = other.getTokenSecret();
        if (this$tokenSecret == null ? other$tokenSecret != null : !this$tokenSecret.equals(other$tokenSecret)) {
            return false;
        }
        OAuth1AddDataType this$addDataType = this.getAddDataType();
        OAuth1AddDataType other$addDataType = other.getAddDataType();
        return !(this$addDataType == null ? other$addDataType != null : !((Object)((Object)this$addDataType)).equals((Object)other$addDataType));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof OAuth1AuthorizationSaveRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : $httpMethod.hashCode());
        OAuth1SignatureMethod $signatureMethod = this.getSignatureMethod();
        result = result * 59 + ($signatureMethod == null ? 43 : ((Object)((Object)$signatureMethod)).hashCode());
        String $consumerKey = this.getConsumerKey();
        result = result * 59 + ($consumerKey == null ? 43 : $consumerKey.hashCode());
        String $consumerSecret = this.getConsumerSecret();
        result = result * 59 + ($consumerSecret == null ? 43 : $consumerSecret.hashCode());
        String $accessToken = this.getAccessToken();
        result = result * 59 + ($accessToken == null ? 43 : $accessToken.hashCode());
        String $tokenSecret = this.getTokenSecret();
        result = result * 59 + ($tokenSecret == null ? 43 : $tokenSecret.hashCode());
        OAuth1AddDataType $addDataType = this.getAddDataType();
        result = result * 59 + ($addDataType == null ? 43 : ((Object)((Object)$addDataType)).hashCode());
        return result;
    }
}

