/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.context;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.qubership.atp.itf.lite.backend.enums.ContextScope;
import org.qubership.atp.itf.lite.backend.model.api.request.ContextVariable;
import org.qubership.atp.itf.lite.backend.model.api.response.environments.System;
import org.springframework.util.CollectionUtils;

public class SaveRequestResolvingContext {
    private Map<String, Object> globals;
    private Map<String, Object> collectionVariables;
    private Map<String, Object> environment;
    private Map<String, Object> iterationData;
    private Map<String, Object> variables;
    private Map<String, Object> environmentVariables;
    private static final Pattern contextKeysPattern = Pattern.compile("^(?<scope>ITF_LITE_GLOBALS_|ITF_LITE_COLLECTIONVARIABLES_|ITF_LITE_ENVIRONMENT_|ITF_LITE_ITERATIONDATA_)(?<key>.*)");

    public static Map<String, Object> parseScope(Map<String, Object> context, ContextScope scope) {
        HashMap<String, Object> parsedScope = new HashMap<String, Object>();
        if (Objects.nonNull(context)) {
            for (Map.Entry<String, Object> entry : context.entrySet()) {
                String key = entry.getKey();
                Object value = entry.getValue();
                Matcher matcher = contextKeysPattern.matcher(key);
                if (scope == ContextScope.LOCAL_VARIABLES) {
                    if (matcher.matches()) continue;
                    parsedScope.put(key, value);
                    continue;
                }
                if (!matcher.matches()) continue;
                String variableScope = matcher.group("scope");
                String parsedKey = matcher.group("key");
                if (!variableScope.equals(scope.getPrefix())) continue;
                parsedScope.put(parsedKey, value);
            }
        }
        return parsedScope;
    }

    public static Map<String, Object> parseSystems(List<System> systems) {
        HashMap<String, Object> environmentVariables = new HashMap<String, Object>();
        if (Objects.isNull(systems)) {
            return environmentVariables;
        }
        systems.stream().filter(s -> !CollectionUtils.isEmpty(s.getConnections())).forEach(s -> s.getConnections().stream().filter(c -> !CollectionUtils.isEmpty((Map)c.getParameters())).forEach(c -> c.getParameters().forEach((k, v) -> environmentVariables.put(String.format("%s.%s.%s", s.getName(), c.getName(), k).toLowerCase(), v))));
        return environmentVariables;
    }

    public Map<String, Object> mergeScopes() {
        HashMap<String, Object> mergedScope = new HashMap<String, Object>();
        mergedScope.putAll(this.globals);
        mergedScope.putAll(this.collectionVariables);
        mergedScope.putAll(this.environment);
        mergedScope.putAll(this.iterationData);
        mergedScope.putAll(this.variables);
        return mergedScope;
    }

    public Map<String, Object> mergeWithScopePrefixes() {
        HashMap<String, Object> mergedScope = new HashMap<String, Object>();
        this.globals.forEach((k, v) -> mergedScope.put(ContextScope.GLOBALS.getPrefix() + k, v));
        this.collectionVariables.forEach((k, v) -> mergedScope.put(ContextScope.COLLECTION.getPrefix() + k, v));
        this.environment.forEach((k, v) -> mergedScope.put(ContextScope.ENVIRONMENT.getPrefix() + k, v));
        this.iterationData.forEach((k, v) -> mergedScope.put(ContextScope.DATA.getPrefix() + k, v));
        mergedScope.putAll(this.variables);
        return mergedScope;
    }

    public void parseAndClassifyContextVariables(List<ContextVariable> contextVariables) {
        if (!CollectionUtils.isEmpty(contextVariables)) {
            for (ContextVariable contextVariable : contextVariables) {
                switch (contextVariable.getContextVariableType()) {
                    case GLOBAL: {
                        this.globals.put(contextVariable.getKey(), contextVariable.getValue());
                        break;
                    }
                    case COLLECTION: {
                        this.collectionVariables.put(contextVariable.getKey(), contextVariable.getValue());
                        break;
                    }
                    case DATA: {
                        this.iterationData.put(contextVariable.getKey(), contextVariable.getValue());
                        break;
                    }
                    case ENVIRONMENT: {
                        this.environment.put(contextVariable.getKey(), contextVariable.getValue());
                        break;
                    }
                    case LOCAL: {
                        this.variables.put(contextVariable.getKey(), contextVariable.getValue());
                        break;
                    }
                }
            }
        }
    }

    private static Map<String, Object> $default$globals() {
        return new LinkedHashMap<String, Object>();
    }

    private static Map<String, Object> $default$collectionVariables() {
        return new LinkedHashMap<String, Object>();
    }

    private static Map<String, Object> $default$environment() {
        return new LinkedHashMap<String, Object>();
    }

    private static Map<String, Object> $default$iterationData() {
        return new LinkedHashMap<String, Object>();
    }

    private static Map<String, Object> $default$variables() {
        return new LinkedHashMap<String, Object>();
    }

    SaveRequestResolvingContext(Map<String, Object> globals, Map<String, Object> collectionVariables, Map<String, Object> environment, Map<String, Object> iterationData, Map<String, Object> variables, Map<String, Object> environmentVariables) {
        this.globals = globals;
        this.collectionVariables = collectionVariables;
        this.environment = environment;
        this.iterationData = iterationData;
        this.variables = variables;
        this.environmentVariables = environmentVariables;
    }

    public static SaveRequestResolvingContextBuilder builder() {
        return new SaveRequestResolvingContextBuilder();
    }

    public Map<String, Object> getGlobals() {
        return this.globals;
    }

    public Map<String, Object> getCollectionVariables() {
        return this.collectionVariables;
    }

    public Map<String, Object> getEnvironment() {
        return this.environment;
    }

    public Map<String, Object> getIterationData() {
        return this.iterationData;
    }

    public Map<String, Object> getVariables() {
        return this.variables;
    }

    public Map<String, Object> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setGlobals(Map<String, Object> globals) {
        this.globals = globals;
    }

    public void setCollectionVariables(Map<String, Object> collectionVariables) {
        this.collectionVariables = collectionVariables;
    }

    public void setEnvironment(Map<String, Object> environment) {
        this.environment = environment;
    }

    public void setIterationData(Map<String, Object> iterationData) {
        this.iterationData = iterationData;
    }

    public void setVariables(Map<String, Object> variables) {
        this.variables = variables;
    }

    public void setEnvironmentVariables(Map<String, Object> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SaveRequestResolvingContext)) {
            return false;
        }
        SaveRequestResolvingContext other = (SaveRequestResolvingContext)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, Object> this$globals = this.getGlobals();
        Map<String, Object> other$globals = other.getGlobals();
        if (this$globals == null ? other$globals != null : !((Object)this$globals).equals(other$globals)) {
            return false;
        }
        Map<String, Object> this$collectionVariables = this.getCollectionVariables();
        Map<String, Object> other$collectionVariables = other.getCollectionVariables();
        if (this$collectionVariables == null ? other$collectionVariables != null : !((Object)this$collectionVariables).equals(other$collectionVariables)) {
            return false;
        }
        Map<String, Object> this$environment = this.getEnvironment();
        Map<String, Object> other$environment = other.getEnvironment();
        if (this$environment == null ? other$environment != null : !((Object)this$environment).equals(other$environment)) {
            return false;
        }
        Map<String, Object> this$iterationData = this.getIterationData();
        Map<String, Object> other$iterationData = other.getIterationData();
        if (this$iterationData == null ? other$iterationData != null : !((Object)this$iterationData).equals(other$iterationData)) {
            return false;
        }
        Map<String, Object> this$variables = this.getVariables();
        Map<String, Object> other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !((Object)this$variables).equals(other$variables)) {
            return false;
        }
        Map<String, Object> this$environmentVariables = this.getEnvironmentVariables();
        Map<String, Object> other$environmentVariables = other.getEnvironmentVariables();
        return !(this$environmentVariables == null ? other$environmentVariables != null : !((Object)this$environmentVariables).equals(other$environmentVariables));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SaveRequestResolvingContext;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, Object> $globals = this.getGlobals();
        result = result * 59 + ($globals == null ? 43 : ((Object)$globals).hashCode());
        Map<String, Object> $collectionVariables = this.getCollectionVariables();
        result = result * 59 + ($collectionVariables == null ? 43 : ((Object)$collectionVariables).hashCode());
        Map<String, Object> $environment = this.getEnvironment();
        result = result * 59 + ($environment == null ? 43 : ((Object)$environment).hashCode());
        Map<String, Object> $iterationData = this.getIterationData();
        result = result * 59 + ($iterationData == null ? 43 : ((Object)$iterationData).hashCode());
        Map<String, Object> $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : ((Object)$variables).hashCode());
        Map<String, Object> $environmentVariables = this.getEnvironmentVariables();
        result = result * 59 + ($environmentVariables == null ? 43 : ((Object)$environmentVariables).hashCode());
        return result;
    }

    public String toString() {
        return "SaveRequestResolvingContext(globals=" + this.getGlobals() + ", collectionVariables=" + this.getCollectionVariables() + ", environment=" + this.getEnvironment() + ", iterationData=" + this.getIterationData() + ", variables=" + this.getVariables() + ", environmentVariables=" + this.getEnvironmentVariables() + ")";
    }

    public static class SaveRequestResolvingContextBuilder {
        private boolean globals$set;
        private Map<String, Object> globals$value;
        private boolean collectionVariables$set;
        private Map<String, Object> collectionVariables$value;
        private boolean environment$set;
        private Map<String, Object> environment$value;
        private boolean iterationData$set;
        private Map<String, Object> iterationData$value;
        private boolean variables$set;
        private Map<String, Object> variables$value;
        private Map<String, Object> environmentVariables;

        SaveRequestResolvingContextBuilder() {
        }

        public SaveRequestResolvingContextBuilder globals(Map<String, Object> globals) {
            this.globals$value = globals;
            this.globals$set = true;
            return this;
        }

        public SaveRequestResolvingContextBuilder collectionVariables(Map<String, Object> collectionVariables) {
            this.collectionVariables$value = collectionVariables;
            this.collectionVariables$set = true;
            return this;
        }

        public SaveRequestResolvingContextBuilder environment(Map<String, Object> environment) {
            this.environment$value = environment;
            this.environment$set = true;
            return this;
        }

        public SaveRequestResolvingContextBuilder iterationData(Map<String, Object> iterationData) {
            this.iterationData$value = iterationData;
            this.iterationData$set = true;
            return this;
        }

        public SaveRequestResolvingContextBuilder variables(Map<String, Object> variables) {
            this.variables$value = variables;
            this.variables$set = true;
            return this;
        }

        public SaveRequestResolvingContextBuilder environmentVariables(Map<String, Object> environmentVariables) {
            this.environmentVariables = environmentVariables;
            return this;
        }

        public SaveRequestResolvingContext build() {
            Map globals$value = this.globals$value;
            if (!this.globals$set) {
                globals$value = SaveRequestResolvingContext.$default$globals();
            }
            Map collectionVariables$value = this.collectionVariables$value;
            if (!this.collectionVariables$set) {
                collectionVariables$value = SaveRequestResolvingContext.$default$collectionVariables();
            }
            Map environment$value = this.environment$value;
            if (!this.environment$set) {
                environment$value = SaveRequestResolvingContext.$default$environment();
            }
            Map iterationData$value = this.iterationData$value;
            if (!this.iterationData$set) {
                iterationData$value = SaveRequestResolvingContext.$default$iterationData();
            }
            Map variables$value = this.variables$value;
            if (!this.variables$set) {
                variables$value = SaveRequestResolvingContext.$default$variables();
            }
            return new SaveRequestResolvingContext(globals$value, collectionVariables$value, environment$value, iterationData$value, variables$value, this.environmentVariables);
        }

        public String toString() {
            return "SaveRequestResolvingContext.SaveRequestResolvingContextBuilder(globals$value=" + this.globals$value + ", collectionVariables$value=" + this.collectionVariables$value + ", environment$value=" + this.environment$value + ", iterationData$value=" + this.iterationData$value + ", variables$value=" + this.variables$value + ", environmentVariables=" + this.environmentVariables + ")";
        }
    }
}

