/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.ei;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanFile;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanFormData;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanGraphql;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanMapDescriptionAndType;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanMode;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;

public class ToPostmanBody {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ToPostmanMode mode;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String raw;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ToPostmanGraphql graphql;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ToPostmanMapDescriptionAndType> urlencoded;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ToPostmanFormData> formdata;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ToPostmanFile file;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private boolean disabled;

    public ToPostmanBody(HttpRequest request) {
        RequestBody body = request.getBody();
        this.disabled = false;
        if (body.getType() != null) {
            this.mode = ToPostmanMode.from(body.getType());
            switch (this.mode) {
                case RAW: {
                    this.raw = body.getContent();
                    break;
                }
                case URLENCODED: {
                    this.urlencoded = new ArrayList<ToPostmanMapDescriptionAndType>();
                    break;
                }
                case FORMDATA: {
                    this.formdata = new ArrayList<ToPostmanFormData>();
                    body.getFormDataBody().forEach(formDataPart -> {
                        switch (formDataPart.getType()) {
                            case FILE: {
                                this.formdata.add(ToPostmanFormData.file(formDataPart.getKey(), formDataPart.getDescription(), "collection/Files/" + request.getId() + "/" + formDataPart.getValue()));
                                break;
                            }
                            case TEXT: {
                                this.formdata.add(ToPostmanFormData.text(formDataPart.getKey(), formDataPart.getValue(), formDataPart.getDescription()));
                                break;
                            }
                        }
                    });
                    break;
                }
                case FILE: {
                    break;
                }
                case GRAPHQL: {
                    this.graphql = new ToPostmanGraphql(body.getQuery(), body.getVariables());
                    break;
                }
            }
        }
    }

    public ToPostmanMode getMode() {
        return this.mode;
    }

    public String getRaw() {
        return this.raw;
    }

    public ToPostmanGraphql getGraphql() {
        return this.graphql;
    }

    public List<ToPostmanMapDescriptionAndType> getUrlencoded() {
        return this.urlencoded;
    }

    public List<ToPostmanFormData> getFormdata() {
        return this.formdata;
    }

    public ToPostmanFile getFile() {
        return this.file;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setFile(ToPostmanFile file) {
        this.file = file;
    }
}

