/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.ei;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.List;
import java.util.stream.Collectors;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanAuth;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanBody;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanHeader;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanUrl;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;
import org.springframework.util.CollectionUtils;

public class ToPostmanRequest {
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String description;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private HttpMethod method;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ToPostmanHeader> header;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ToPostmanBody body;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ToPostmanUrl url;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private ToPostmanAuth auth;

    public ToPostmanRequest(HttpRequest request) {
        RequestBody body;
        this.description = request.getName();
        this.method = request.getHttpMethod();
        if (request.getRequestHeaders() != null) {
            this.header = request.getRequestHeaders().stream().map(ToPostmanHeader::new).collect(Collectors.toList());
        }
        if ((body = request.getBody()) != null && this.isBodyHasAContent(body)) {
            this.body = new ToPostmanBody(request);
        }
        if (request.getUrl() != null) {
            this.url = new ToPostmanUrl(request.getUrl());
        }
        this.auth = new ToPostmanAuth(request.getAuthorization());
    }

    public boolean isBodyHasAContent(RequestBody body) {
        return body.getContent() != null || body.getQuery() != null || body.getVariables() != null || !CollectionUtils.isEmpty(body.getFormDataBody());
    }

    public String getDescription() {
        return this.description;
    }

    public HttpMethod getMethod() {
        return this.method;
    }

    public List<ToPostmanHeader> getHeader() {
        return this.header;
    }

    public ToPostmanBody getBody() {
        return this.body;
    }

    public ToPostmanUrl getUrl() {
        return this.url;
    }

    public ToPostmanAuth getAuth() {
        return this.auth;
    }
}

