/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.ei;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.logging.log4j.util.Strings;
import org.qubership.atp.itf.lite.backend.model.ei.ToPostmanMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ToPostmanUrl {
    private static final Logger log = LoggerFactory.getLogger(ToPostmanUrl.class);
    private String raw;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String protocol;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> host;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private String port;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<String> path;
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    private List<ToPostmanMap> query;

    public ToPostmanUrl(String urlString) {
        this.raw = urlString;
        try {
            URL url = new URL(urlString);
            this.protocol = url.getProtocol();
            if (Strings.isNotBlank((String)url.getHost())) {
                this.host = Arrays.asList(url.getHost().split("\\."));
            }
            if (url.getPort() != -1) {
                this.port = String.valueOf(url.getPort());
            }
            if (Strings.isNotBlank((String)url.getPath())) {
                String path = url.getPath().startsWith("/") ? url.getPath().replaceFirst("/", "") : url.getPath();
                this.path = Arrays.asList(path.split("/"));
            }
            if (Strings.isNotBlank((String)url.getQuery())) {
                this.query = Arrays.stream(url.getQuery().split("&")).map(s -> {
                    String[] keyValue = s.split("=");
                    return new ToPostmanMap(keyValue[0], keyValue.length == 2 ? keyValue[1] : null);
                }).collect(Collectors.toList());
            }
        }
        catch (MalformedURLException e) {
            this.host = Arrays.asList(urlString);
            log.warn("Failed to parse URL '{}' during export to POSTMAN", (Object)urlString);
        }
    }

    public String getRaw() {
        return this.raw;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public List<String> getHost() {
        return this.host;
    }

    public String getPort() {
        return this.port;
    }

    public List<String> getPath() {
        return this.path;
    }

    public List<ToPostmanMap> getQuery() {
        return this.query;
    }
}

