/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.UUID;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.qubership.atp.itf.lite.backend.enums.TransportType;
import org.qubership.atp.itf.lite.backend.model.api.response.ParentRequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractNamedEntity;
import org.qubership.atp.itf.lite.backend.model.entities.auth.RequestAuthorization;
import org.qubership.atp.itf.lite.backend.model.entities.http.HttpRequest;

@Entity
@Table(name="requests")
@Inheritance(strategy=InheritanceType.JOINED)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="transportType", visible=true)
@JsonSubTypes(value={@JsonSubTypes.Type(value=HttpRequest.class, name="REST"), @JsonSubTypes.Type(value=HttpRequest.class, name="SOAP")})
public abstract class Request
extends AbstractNamedEntity {
    @Column(name="project_id")
    @DiffInclude
    protected UUID projectId;
    @Column(name="folder_id")
    @DiffInclude
    protected UUID folderId;
    @Enumerated(value=EnumType.STRING)
    @Column(name="transport_type")
    @DiffInclude
    protected TransportType transportType;
    @OneToOne(cascade={CascadeType.ALL}, orphanRemoval=true)
    @JoinColumn(name="authorization_id")
    @DiffInclude
    protected RequestAuthorization authorization;
    @Column(name="`order`")
    @DiffInclude
    private Integer order;
    @Column(name="source_id")
    @DiffInclude
    private UUID sourceId;
    @Column(name="prescripts")
    @DiffInclude
    private String preScripts;
    @Column(name="postscripts")
    @DiffInclude
    private String postScripts;
    @Column(name="permission_folder_id")
    @DiffInclude
    private UUID permissionFolderId;
    @Column(name="disable_cookie_generation")
    @DiffInclude
    private boolean isAutoCookieDisabled;
    @Column(name="disable_ssl_certificate_verification")
    @DiffInclude
    private boolean disableSslCertificateVerification;
    @Column(name="disable_ssl_client_certificate")
    @DiffInclude
    private boolean disableSslClientCertificate;
    @Column(name="disable_following_redirect")
    @DiffInclude
    private boolean disableFollowingRedirect;
    @Column(name="disable_auto_encoding")
    @DiffInclude
    private boolean disableAutoEncoding;
    @Column(name="description", columnDefinition="TEXT")
    private String description;
    @Transient
    private boolean hasWritePermissions;
    @Transient
    private ParentRequestAuthorization parentAuth;

    public Request(Request request) {
        this.id = request.getId();
        this.name = request.getName();
        this.projectId = request.getProjectId();
        this.folderId = request.getFolderId();
        this.transportType = request.getTransportType();
        this.authorization = request.authorization;
        this.order = request.order;
        this.sourceId = request.getSourceId();
        this.preScripts = request.getPreScripts();
        this.postScripts = request.getPostScripts();
        this.permissionFolderId = request.getPermissionFolderId();
        this.isAutoCookieDisabled = request.isAutoCookieDisabled();
        this.disableSslCertificateVerification = request.isDisableSslCertificateVerification();
        this.disableSslClientCertificate = request.isDisableSslClientCertificate();
        this.disableFollowingRedirect = request.isDisableFollowingRedirect();
        this.description = request.getDescription();
        this.parentAuth = request.getParentAuth();
    }

    @JsonProperty(value="isAutoCookieDisabled")
    public boolean isAutoCookieDisabled() {
        return this.isAutoCookieDisabled;
    }

    public void setAutoCookieDisabled(boolean isAutoCookieDisabled) {
        this.isAutoCookieDisabled = isAutoCookieDisabled;
    }

    public UUID getProjectId() {
        return this.projectId;
    }

    public UUID getFolderId() {
        return this.folderId;
    }

    public TransportType getTransportType() {
        return this.transportType;
    }

    public RequestAuthorization getAuthorization() {
        return this.authorization;
    }

    public Integer getOrder() {
        return this.order;
    }

    public UUID getSourceId() {
        return this.sourceId;
    }

    public String getPreScripts() {
        return this.preScripts;
    }

    public String getPostScripts() {
        return this.postScripts;
    }

    public UUID getPermissionFolderId() {
        return this.permissionFolderId;
    }

    public boolean isDisableSslCertificateVerification() {
        return this.disableSslCertificateVerification;
    }

    public boolean isDisableSslClientCertificate() {
        return this.disableSslClientCertificate;
    }

    public boolean isDisableFollowingRedirect() {
        return this.disableFollowingRedirect;
    }

    public boolean isDisableAutoEncoding() {
        return this.disableAutoEncoding;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isHasWritePermissions() {
        return this.hasWritePermissions;
    }

    public ParentRequestAuthorization getParentAuth() {
        return this.parentAuth;
    }

    public void setProjectId(UUID projectId) {
        this.projectId = projectId;
    }

    public void setFolderId(UUID folderId) {
        this.folderId = folderId;
    }

    public void setTransportType(TransportType transportType) {
        this.transportType = transportType;
    }

    public void setAuthorization(RequestAuthorization authorization) {
        this.authorization = authorization;
    }

    public void setOrder(Integer order) {
        this.order = order;
    }

    public void setSourceId(UUID sourceId) {
        this.sourceId = sourceId;
    }

    public void setPreScripts(String preScripts) {
        this.preScripts = preScripts;
    }

    public void setPostScripts(String postScripts) {
        this.postScripts = postScripts;
    }

    public void setPermissionFolderId(UUID permissionFolderId) {
        this.permissionFolderId = permissionFolderId;
    }

    public void setDisableSslCertificateVerification(boolean disableSslCertificateVerification) {
        this.disableSslCertificateVerification = disableSslCertificateVerification;
    }

    public void setDisableSslClientCertificate(boolean disableSslClientCertificate) {
        this.disableSslClientCertificate = disableSslClientCertificate;
    }

    public void setDisableFollowingRedirect(boolean disableFollowingRedirect) {
        this.disableFollowingRedirect = disableFollowingRedirect;
    }

    public void setDisableAutoEncoding(boolean disableAutoEncoding) {
        this.disableAutoEncoding = disableAutoEncoding;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setHasWritePermissions(boolean hasWritePermissions) {
        this.hasWritePermissions = hasWritePermissions;
    }

    public void setParentAuth(ParentRequestAuthorization parentAuth) {
        this.parentAuth = parentAuth;
    }

    @Override
    public String toString() {
        return "Request(projectId=" + this.getProjectId() + ", folderId=" + this.getFolderId() + ", transportType=" + (Object)((Object)this.getTransportType()) + ", authorization=" + this.getAuthorization() + ", order=" + this.getOrder() + ", sourceId=" + this.getSourceId() + ", preScripts=" + this.getPreScripts() + ", postScripts=" + this.getPostScripts() + ", permissionFolderId=" + this.getPermissionFolderId() + ", isAutoCookieDisabled=" + this.isAutoCookieDisabled() + ", disableSslCertificateVerification=" + this.isDisableSslCertificateVerification() + ", disableSslClientCertificate=" + this.isDisableSslClientCertificate() + ", disableFollowingRedirect=" + this.isDisableFollowingRedirect() + ", disableAutoEncoding=" + this.isDisableAutoEncoding() + ", description=" + this.getDescription() + ", hasWritePermissions=" + this.isHasWritePermissions() + ", parentAuth=" + this.getParentAuth() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Request)) {
            return false;
        }
        Request other = (Request)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isAutoCookieDisabled() != other.isAutoCookieDisabled()) {
            return false;
        }
        if (this.isDisableSslCertificateVerification() != other.isDisableSslCertificateVerification()) {
            return false;
        }
        if (this.isDisableSslClientCertificate() != other.isDisableSslClientCertificate()) {
            return false;
        }
        if (this.isDisableFollowingRedirect() != other.isDisableFollowingRedirect()) {
            return false;
        }
        if (this.isDisableAutoEncoding() != other.isDisableAutoEncoding()) {
            return false;
        }
        if (this.isHasWritePermissions() != other.isHasWritePermissions()) {
            return false;
        }
        Integer this$order = this.getOrder();
        Integer other$order = other.getOrder();
        if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
            return false;
        }
        UUID this$projectId = this.getProjectId();
        UUID other$projectId = other.getProjectId();
        if (this$projectId == null ? other$projectId != null : !((Object)this$projectId).equals(other$projectId)) {
            return false;
        }
        UUID this$folderId = this.getFolderId();
        UUID other$folderId = other.getFolderId();
        if (this$folderId == null ? other$folderId != null : !((Object)this$folderId).equals(other$folderId)) {
            return false;
        }
        TransportType this$transportType = this.getTransportType();
        TransportType other$transportType = other.getTransportType();
        if (this$transportType == null ? other$transportType != null : !((Object)((Object)this$transportType)).equals((Object)other$transportType)) {
            return false;
        }
        RequestAuthorization this$authorization = this.getAuthorization();
        RequestAuthorization other$authorization = other.getAuthorization();
        if (this$authorization == null ? other$authorization != null : !((Object)this$authorization).equals(other$authorization)) {
            return false;
        }
        UUID this$sourceId = this.getSourceId();
        UUID other$sourceId = other.getSourceId();
        if (this$sourceId == null ? other$sourceId != null : !((Object)this$sourceId).equals(other$sourceId)) {
            return false;
        }
        String this$preScripts = this.getPreScripts();
        String other$preScripts = other.getPreScripts();
        if (this$preScripts == null ? other$preScripts != null : !this$preScripts.equals(other$preScripts)) {
            return false;
        }
        String this$postScripts = this.getPostScripts();
        String other$postScripts = other.getPostScripts();
        if (this$postScripts == null ? other$postScripts != null : !this$postScripts.equals(other$postScripts)) {
            return false;
        }
        UUID this$permissionFolderId = this.getPermissionFolderId();
        UUID other$permissionFolderId = other.getPermissionFolderId();
        if (this$permissionFolderId == null ? other$permissionFolderId != null : !((Object)this$permissionFolderId).equals(other$permissionFolderId)) {
            return false;
        }
        String this$description = this.getDescription();
        String other$description = other.getDescription();
        if (this$description == null ? other$description != null : !this$description.equals(other$description)) {
            return false;
        }
        ParentRequestAuthorization this$parentAuth = this.getParentAuth();
        ParentRequestAuthorization other$parentAuth = other.getParentAuth();
        return !(this$parentAuth == null ? other$parentAuth != null : !((Object)this$parentAuth).equals(other$parentAuth));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof Request;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isAutoCookieDisabled() ? 79 : 97);
        result = result * 59 + (this.isDisableSslCertificateVerification() ? 79 : 97);
        result = result * 59 + (this.isDisableSslClientCertificate() ? 79 : 97);
        result = result * 59 + (this.isDisableFollowingRedirect() ? 79 : 97);
        result = result * 59 + (this.isDisableAutoEncoding() ? 79 : 97);
        result = result * 59 + (this.isHasWritePermissions() ? 79 : 97);
        Integer $order = this.getOrder();
        result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
        UUID $projectId = this.getProjectId();
        result = result * 59 + ($projectId == null ? 43 : ((Object)$projectId).hashCode());
        UUID $folderId = this.getFolderId();
        result = result * 59 + ($folderId == null ? 43 : ((Object)$folderId).hashCode());
        TransportType $transportType = this.getTransportType();
        result = result * 59 + ($transportType == null ? 43 : ((Object)((Object)$transportType)).hashCode());
        RequestAuthorization $authorization = this.getAuthorization();
        result = result * 59 + ($authorization == null ? 43 : ((Object)$authorization).hashCode());
        UUID $sourceId = this.getSourceId();
        result = result * 59 + ($sourceId == null ? 43 : ((Object)$sourceId).hashCode());
        String $preScripts = this.getPreScripts();
        result = result * 59 + ($preScripts == null ? 43 : $preScripts.hashCode());
        String $postScripts = this.getPostScripts();
        result = result * 59 + ($postScripts == null ? 43 : $postScripts.hashCode());
        UUID $permissionFolderId = this.getPermissionFolderId();
        result = result * 59 + ($permissionFolderId == null ? 43 : ((Object)$permissionFolderId).hashCode());
        String $description = this.getDescription();
        result = result * 59 + ($description == null ? 43 : $description.hashCode());
        ParentRequestAuthorization $parentAuth = this.getParentAuth();
        result = result * 59 + ($parentAuth == null ? 43 : ((Object)$parentAuth).hashCode());
        return result;
    }

    public Request() {
    }
}

