/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import org.apache.commons.lang.StringUtils;
import org.apache.http.entity.ContentType;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.javers.core.metamodel.annotation.ValueObject;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.qubership.atp.itf.lite.backend.annotations.SerializableCheckable;
import org.qubership.atp.itf.lite.backend.enums.ValueType;
import org.qubership.atp.itf.lite.backend.enums.http.RequestBodyType;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanBodyDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanFormDataPartDescriptionDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanFormDataPartDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanFormDataPartTypeDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanGraphQlBodyDto;
import org.qubership.atp.itf.lite.backend.feign.dto.PostmanRequestBodyModeDto;
import org.qubership.atp.itf.lite.backend.model.entities.FileBody;
import org.qubership.atp.itf.lite.backend.model.entities.gridfs.FileData;
import org.qubership.atp.itf.lite.backend.model.entities.http.FormDataPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

@Embeddable
@ValueObject
@SerializableCheckable
public class RequestBody
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(RequestBody.class);
    private static final ObjectMapper objectMapper = new ObjectMapper(){
        {
            this.registerModule((Module)new JavaTimeModule());
            this.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            this.configure(SerializationFeature.INDENT_OUTPUT, false);
            this.findAndRegisterModules();
        }
    };
    @Column(name="content", columnDefinition="TEXT")
    @DiffInclude
    private String content;
    @Column(name="query", columnDefinition="TEXT")
    @DiffInclude
    private String query;
    @Column(name="variables", columnDefinition="TEXT")
    @DiffInclude
    private String variables;
    @Enumerated(value=EnumType.STRING)
    @Column(name="type")
    @DiffInclude
    private RequestBodyType type;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="request_id")
    @DiffInclude
    private List<FormDataPart> formDataBody;
    @Embedded
    @DiffInclude
    private FileBody binaryBody;

    public RequestBody(String content, RequestBodyType type) {
        this.content = content;
        this.type = type;
    }

    public RequestBody(String query, String variables, RequestBodyType type) {
        this.query = query;
        this.variables = variables;
        this.type = type;
    }

    public RequestBody(List<FormDataPart> formDataBody, RequestBodyType type) {
        this.formDataBody = formDataBody;
        this.type = type;
    }

    public RequestBody(FileBody fileBody, RequestBodyType type) {
        this.binaryBody = fileBody;
        this.type = type;
    }

    @JsonIgnore
    public PostmanBodyDto getPostmanBody(FileData file) {
        PostmanBodyDto body = new PostmanBodyDto();
        if (RequestBodyType.FORM_DATA.equals((Object)this.type)) {
            body.setMode(PostmanRequestBodyModeDto.FORMDATA);
            List<PostmanFormDataPartDto> postmanFdp = new ArrayList<PostmanFormDataPartDto>();
            if (!CollectionUtils.isEmpty(this.formDataBody)) {
                postmanFdp = this.formDataBody.stream().map(fdp -> {
                    PostmanFormDataPartDto pfdp = new PostmanFormDataPartDto();
                    pfdp.setKey(fdp.getKey());
                    if (ValueType.TEXT.equals((Object)fdp.getType())) {
                        pfdp.setType(PostmanFormDataPartTypeDto.TEXT);
                        pfdp.setValue(fdp.getValue());
                    } else {
                        pfdp.setType(PostmanFormDataPartTypeDto.FILE);
                        pfdp.setSrc(Objects.isNull(fdp.getFileId()) ? null : fdp.getFileId().toString());
                        pfdp.setFileName(fdp.getValue());
                    }
                    pfdp.setContentType(fdp.getContentType());
                    pfdp.setDescription(new PostmanFormDataPartDescriptionDto().content(fdp.getDescription()).type(ContentType.TEXT_PLAIN.getMimeType()));
                    pfdp.setDisabled(fdp.isDisabled());
                    return pfdp;
                }).collect(Collectors.toList());
            }
            body.setMode(PostmanRequestBodyModeDto.FORMDATA);
            body.setFormdata(postmanFdp);
        } else if (RequestBodyType.GraphQL.equals((Object)this.getType())) {
            body.setMode(PostmanRequestBodyModeDto.GRAPHQL);
            body.setGraphql(new PostmanGraphQlBodyDto().query(this.getQuery()).variables(this.getVariables()));
        } else if (RequestBodyType.Binary.equals((Object)this.getType()) && file != null) {
            body.setMode(PostmanRequestBodyModeDto.FILE);
            body.setFile(file.getFileName());
        } else {
            body.setMode(PostmanRequestBodyModeDto.RAW);
            body.setRaw(this.content);
        }
        return body;
    }

    public void updateFromPostmanBody(PostmanBodyDto postmanBody) {
        block8: {
            block7: {
                if (!Objects.nonNull((Object)postmanBody.getMode())) break block7;
                switch (postmanBody.getMode()) {
                    case GRAPHQL: {
                        this.type = RequestBodyType.GraphQL;
                        this.setQuery(postmanBody.getGraphql().getQuery());
                        this.setVariables(postmanBody.getGraphql().getVariables());
                        break;
                    }
                    case FILE: {
                        this.type = RequestBodyType.Binary;
                        break;
                    }
                    case FORMDATA: {
                        this.type = RequestBodyType.FORM_DATA;
                        if (!CollectionUtils.isEmpty(postmanBody.getFormdata())) {
                            this.formDataBody = postmanBody.getFormdata().stream().map(pfdp -> {
                                FormDataPart fdp = new FormDataPart();
                                fdp.setKey(pfdp.getKey());
                                if (PostmanFormDataPartTypeDto.TEXT.equals((Object)pfdp.getType())) {
                                    fdp.setType(ValueType.TEXT);
                                    fdp.setValue(pfdp.getValue());
                                } else {
                                    fdp.setType(ValueType.FILE);
                                    fdp.setFileId(StringUtils.isEmpty((String)pfdp.getSrc()) ? null : UUID.fromString(pfdp.getSrc()));
                                    fdp.setValue(pfdp.getFileName());
                                }
                                fdp.setContentType(pfdp.getContentType());
                                fdp.setDescription(pfdp.getDescription().getContent());
                                fdp.setDisabled(pfdp.getDisabled());
                                return fdp;
                            }).collect(Collectors.toList());
                            break;
                        }
                        break block8;
                    }
                    case RAW: {
                        this.type = RequestBodyType.JSON;
                        this.content = postmanBody.getRaw();
                        break;
                    }
                }
                break block8;
            }
            this.content = postmanBody.getRaw();
        }
    }

    public boolean detectAndFillGraphQlProperties(String content) {
        try {
            Map contentParams = (Map)objectMapper.readValue(content.replace("\r\n", "\\r\\n").replace("\n", "\\n"), Map.class);
            if (contentParams.isEmpty() || !contentParams.containsKey("query")) {
                return false;
            }
            this.query = (String)contentParams.get("query");
            this.variables = objectMapper.writeValueAsString((Object)contentParams.getOrDefault("variables", ""));
            this.content = objectMapper.writeValueAsString((Object)contentParams);
            this.type = RequestBodyType.GraphQL;
            return true;
        }
        catch (IOException e) {
            return false;
        }
    }

    public String computeAndGetContent() {
        return RequestBodyType.GraphQL.equals((Object)this.type) ? this.composeGraphQlBody(this.query, this.variables) : StringUtils.defaultString((String)this.content);
    }

    public void computeAndSetContent() {
        if (RequestBodyType.GraphQL.equals((Object)this.type)) {
            this.content = this.composeGraphQlBody(this.query, this.variables);
        }
    }

    public String composeGraphQlBody(String query, String variables) {
        JSONObject jsonObject = new JSONObject();
        String escapedQuery = "";
        if (!StringUtils.isEmpty((String)query)) {
            escapedQuery = StringUtils.replaceEach((String)JSONObject.escape((String)query), (String[])Arrays.asList("\\n", "\\r", "\\t", "\\\"").toArray(new String[0]), (String[])Arrays.asList(" ", " ", " ", "\"").toArray(new String[0]));
        }
        jsonObject.put((Object)"query", (Object)escapedQuery);
        JSONParser parser = new JSONParser();
        try {
            jsonObject.put((Object)"variables", !StringUtils.isEmpty((String)variables) ? parser.parse(variables) : new JSONObject());
        }
        catch (ParseException e) {
            log.warn("Can't parse variables");
            jsonObject.put((Object)"variables", (Object)new JSONObject());
        }
        return jsonObject.toString();
    }

    public String composeGraphQlBody() {
        return this.composeGraphQlBody(this.query, this.variables);
    }

    public String getContent() {
        return this.content;
    }

    public String getQuery() {
        return this.query;
    }

    public String getVariables() {
        return this.variables;
    }

    public RequestBodyType getType() {
        return this.type;
    }

    public List<FormDataPart> getFormDataBody() {
        return this.formDataBody;
    }

    public FileBody getBinaryBody() {
        return this.binaryBody;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setVariables(String variables) {
        this.variables = variables;
    }

    public void setType(RequestBodyType type) {
        this.type = type;
    }

    public void setFormDataBody(List<FormDataPart> formDataBody) {
        this.formDataBody = formDataBody;
    }

    public void setBinaryBody(FileBody binaryBody) {
        this.binaryBody = binaryBody;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestBody)) {
            return false;
        }
        RequestBody other = (RequestBody)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$content = this.getContent();
        String other$content = other.getContent();
        if (this$content == null ? other$content != null : !this$content.equals(other$content)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$variables = this.getVariables();
        String other$variables = other.getVariables();
        if (this$variables == null ? other$variables != null : !this$variables.equals(other$variables)) {
            return false;
        }
        RequestBodyType this$type = this.getType();
        RequestBodyType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<FormDataPart> this$formDataBody = this.getFormDataBody();
        List<FormDataPart> other$formDataBody = other.getFormDataBody();
        if (this$formDataBody == null ? other$formDataBody != null : !((Object)this$formDataBody).equals(other$formDataBody)) {
            return false;
        }
        FileBody this$binaryBody = this.getBinaryBody();
        FileBody other$binaryBody = other.getBinaryBody();
        return !(this$binaryBody == null ? other$binaryBody != null : !((Object)this$binaryBody).equals(other$binaryBody));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestBody;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $content = this.getContent();
        result = result * 59 + ($content == null ? 43 : $content.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $variables = this.getVariables();
        result = result * 59 + ($variables == null ? 43 : $variables.hashCode());
        RequestBodyType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<FormDataPart> $formDataBody = this.getFormDataBody();
        result = result * 59 + ($formDataBody == null ? 43 : ((Object)$formDataBody).hashCode());
        FileBody $binaryBody = this.getBinaryBody();
        result = result * 59 + ($binaryBody == null ? 43 : ((Object)$binaryBody).hashCode());
        return result;
    }

    public String toString() {
        return "RequestBody(content=" + this.getContent() + ", query=" + this.getQuery() + ", variables=" + this.getVariables() + ", type=" + (Object)((Object)this.getType()) + ", formDataBody=" + this.getFormDataBody() + ", binaryBody=" + this.getBinaryBody() + ")";
    }

    public RequestBody() {
    }
}

