/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Converter
@Component
public class HashMapConverter
implements AttributeConverter<Map<String, List<String>>, String> {
    private static final Logger log = LoggerFactory.getLogger(HashMapConverter.class);

    public String convertToDatabaseColumn(Map<String, List<String>> requestParams) {
        String requestParamsJson = null;
        try {
            requestParamsJson = new ObjectMapper().writeValueAsString(requestParams);
        }
        catch (JsonProcessingException e) {
            log.error("JSON writing error", (Throwable)e);
        }
        return requestParamsJson;
    }

    public Map<String, List<String>> convertToEntityAttribute(String requestParamsJson) {
        Map requestParams = null;
        try {
            requestParams = (Map)new ObjectMapper().readValue(requestParamsJson, Map.class);
        }
        catch (IOException e) {
            log.error("JSON reading error", (Throwable)e);
        }
        return requestParams;
    }
}

