/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.qubership.atp.itf.lite.backend.feign.dto.ConsoleLogDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Converter
@Component
public class ListConsoleLogConverter
implements AttributeConverter<List<ConsoleLogDto>, String> {
    private static final Logger log = LoggerFactory.getLogger(ListConsoleLogConverter.class);
    private final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(List<ConsoleLogDto> consoleLogs) {
        String consoleLogJson = null;
        if (consoleLogs != null) {
            try {
                consoleLogJson = this.objectMapper.writeValueAsString(consoleLogs);
            }
            catch (JsonProcessingException e) {
                log.error("JSON writing error", (Throwable)e);
            }
        }
        return consoleLogJson;
    }

    public List<ConsoleLogDto> convertToEntityAttribute(String consoleLogJson) {
        List consoleLogs = null;
        if (consoleLogJson != null) {
            try {
                consoleLogs = (List)this.objectMapper.readValue(consoleLogJson, (TypeReference)new TypeReference<List<ConsoleLogDto>>(){});
            }
            catch (IOException e) {
                log.error("JSON reading error", (Throwable)e);
            }
        }
        return consoleLogs;
    }
}

