/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.apache.logging.log4j.util.Strings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Converter
@Component
public class ListConverter
implements AttributeConverter<List<String>, String> {
    private static final Logger log = LoggerFactory.getLogger(ListConverter.class);

    public String convertToDatabaseColumn(List<String> requestParams) {
        String requestParamsJson = null;
        if (requestParams != null) {
            try {
                requestParamsJson = new ObjectMapper().writeValueAsString(requestParams);
            }
            catch (JsonProcessingException e) {
                log.error("JSON writing error", (Throwable)e);
            }
        }
        return requestParamsJson;
    }

    public List<String> convertToEntityAttribute(String requestParamsJson) {
        List requestParams = null;
        if (Strings.isNotBlank((String)requestParamsJson)) {
            try {
                requestParams = (List)new ObjectMapper().readValue(requestParamsJson, List.class);
            }
            catch (IOException e) {
                log.error("JSON reading error", (Throwable)e);
            }
        }
        return requestParams;
    }
}

