/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.List;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.qubership.atp.itf.lite.backend.model.entities.http.FormDataPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Converter
@Component
public class ListFormDataBodyConverter
implements AttributeConverter<List<FormDataPart>, String> {
    private static final Logger log = LoggerFactory.getLogger(ListFormDataBodyConverter.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(List<FormDataPart> requestParams) {
        String requestParamsJson = null;
        if (requestParams != null) {
            try {
                requestParamsJson = objectMapper.writeValueAsString(requestParams);
            }
            catch (JsonProcessingException e) {
                log.error("JSON writing error", (Throwable)e);
            }
        }
        return requestParamsJson;
    }

    public List<FormDataPart> convertToEntityAttribute(String requestParamsJson) {
        List requestParams = null;
        if (requestParamsJson != null) {
            try {
                requestParams = (List)objectMapper.readValue(requestParamsJson, (TypeReference)new TypeReference<List<FormDataPart>>(){});
            }
            catch (IOException e) {
                log.error("JSON reading error", (Throwable)e);
            }
        }
        return requestParams;
    }
}

