/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;
import org.qubership.atp.itf.lite.backend.model.entities.PermissionEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Converter
@Component
public class PermissionEntityConverter
implements AttributeConverter<PermissionEntity, String> {
    private static final Logger log = LoggerFactory.getLogger(PermissionEntityConverter.class);
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public String convertToDatabaseColumn(PermissionEntity permissionEntity) {
        String permissionEntityJson = null;
        if (permissionEntity != null && permissionEntity.isEnable()) {
            try {
                permissionEntityJson = objectMapper.writeValueAsString((Object)permissionEntity);
            }
            catch (JsonProcessingException e) {
                log.error("JSON writing error", (Throwable)e);
            }
        }
        return permissionEntityJson;
    }

    public PermissionEntity convertToEntityAttribute(String permissionEntityJson) {
        PermissionEntity permissionEntity = new PermissionEntity();
        if (permissionEntityJson != null) {
            try {
                permissionEntity = (PermissionEntity)objectMapper.readValue(permissionEntityJson, PermissionEntity.class);
            }
            catch (IOException e) {
                log.error("JSON reading error", (Throwable)e);
            }
        }
        return permissionEntity;
    }
}

