/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.gridfs;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.qubership.atp.itf.lite.backend.annotations.SerializableCheckable;
import org.springframework.web.multipart.MultipartFile;

@SerializableCheckable
public class FileData
implements MultipartFile,
Serializable {
    private byte[] content;
    private String fileName;
    private UUID fileId;
    private String contentType;

    public FileData(byte[] content, String fileName) {
        this.content = content;
        this.fileName = fileName;
    }

    public FileData(byte[] content, String fileName, String contentType) {
        this.content = content;
        this.fileName = fileName;
        this.contentType = contentType;
    }

    public String getName() {
        return this.fileName;
    }

    public String getOriginalFilename() {
        return this.fileName;
    }

    public boolean isEmpty() {
        return this.content.length == 0;
    }

    public long getSize() {
        return this.content.length;
    }

    public byte[] getBytes() throws IOException {
        return this.content;
    }

    public InputStream getInputStream() throws IOException {
        return new ByteArrayInputStream(this.content);
    }

    public void transferTo(@NotNull File dest) throws IOException, IllegalStateException {
        try (FileOutputStream outputStream = new FileOutputStream(dest);){
            ((OutputStream)outputStream).write(this.getBytes());
        }
    }

    public byte[] getContent() {
        return this.content;
    }

    public String getFileName() {
        return this.fileName;
    }

    public UUID getFileId() {
        return this.fileId;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContent(byte[] content) {
        this.content = content;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setFileId(UUID fileId) {
        this.fileId = fileId;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileData)) {
            return false;
        }
        FileData other = (FileData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getContent(), other.getContent())) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        UUID this$fileId = this.getFileId();
        UUID other$fileId = other.getFileId();
        if (this$fileId == null ? other$fileId != null : !((Object)this$fileId).equals(other$fileId)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        return !(this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileData;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getContent());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        UUID $fileId = this.getFileId();
        result = result * 59 + ($fileId == null ? 43 : ((Object)$fileId).hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        return result;
    }

    public String toString() {
        return "FileData(content=" + Arrays.toString(this.getContent()) + ", fileName=" + this.getFileName() + ", fileId=" + this.getFileId() + ", contentType=" + this.getContentType() + ")";
    }

    public FileData(byte[] content, String fileName, UUID fileId, String contentType) {
        this.content = content;
        this.fileName = fileName;
        this.fileId = fileId;
        this.contentType = contentType;
    }

    public FileData() {
    }
}

