/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.history;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.Table;
import org.qubership.atp.itf.lite.backend.feign.dto.ConsoleLogDto;
import org.qubership.atp.itf.lite.backend.model.api.dto.ResponseCookie;
import org.qubership.atp.itf.lite.backend.model.api.request.ContextVariable;
import org.qubership.atp.itf.lite.backend.model.api.request.RequestEntitySaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.qubership.atp.itf.lite.backend.model.api.response.ErrorResponseSerializable;
import org.qubership.atp.itf.lite.backend.model.api.response.RequestExecutionResponse;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractEntity;
import org.qubership.atp.itf.lite.backend.model.entities.converters.ErrorResponseSerializableConverter;
import org.qubership.atp.itf.lite.backend.model.entities.converters.HttpHeaderSaveRequestConverter;
import org.qubership.atp.itf.lite.backend.model.entities.converters.ListConsoleLogConverter;
import org.qubership.atp.itf.lite.backend.model.entities.converters.ListContextVariableConverter;
import org.qubership.atp.itf.lite.backend.model.entities.converters.ListResponseCookieConverter;
import org.qubership.atp.itf.lite.backend.model.entities.history.HistoryRequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.history.RequestExecution;
import org.qubership.atp.itf.lite.backend.model.entities.history.TestStatus;
import org.qubership.atp.itf.lite.backend.utils.RequestUtils;

@Entity
@Table(name="request_execution_details")
@Inheritance(strategy=InheritanceType.JOINED)
public class RequestExecutionDetails
extends AbstractEntity {
    @OneToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="request_execution_id")
    protected RequestExecution requestExecution;
    @Embedded
    protected HistoryRequestBody requestBody;
    @Column(name="response_body", columnDefinition="TEXT")
    protected String responseBody;
    @Column(name="error_message", columnDefinition="TEXT")
    @Convert(converter=ErrorResponseSerializableConverter.class)
    protected ErrorResponseSerializable errorMessage;
    @Column(name="request_pre_script", columnDefinition="TEXT")
    protected String requestPreScript;
    @Column(name="request_post_script", columnDefinition="TEXT")
    protected String requestPostScript;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="request_execution_details_id")
    protected List<TestStatus> requestTests;
    @Column(name="console_logs")
    @Convert(converter=ListConsoleLogConverter.class)
    protected List<ConsoleLogDto> consoleLogs;
    @Column(name="context_variables")
    @Convert(converter=ListContextVariableConverter.class)
    protected List<ContextVariable> contextVariables;
    @Column(name="cookies")
    @Convert(converter=ListResponseCookieConverter.class)
    protected List<ResponseCookie> cookies;
    @Column(name="cookie_header")
    @Convert(converter=HttpHeaderSaveRequestConverter.class)
    protected HttpHeaderSaveRequest cookieHeader;
    @Column(name="response_body_byte")
    protected byte[] responseBodyByte;

    public void update(RequestExecution requestExecution, RequestEntitySaveRequest request, RequestExecutionResponse response, Exception errorMessage, HistoryRequestBody requestBody) {
        this.requestExecution = requestExecution;
        this.requestBody = requestBody;
        if (response != null && response.getBody() != null) {
            this.responseBodyByte = response.getBody().getBytes(StandardCharsets.UTF_8);
        }
        this.errorMessage = RequestUtils.getErrorResponse(errorMessage);
        this.requestPreScript = request.getPreScripts();
        this.requestPostScript = request.getPostScripts();
    }

    public void addConsoleLog(ConsoleLogDto consoleLog) {
        if (consoleLog != null) {
            if (this.consoleLogs == null) {
                this.consoleLogs = new ArrayList<ConsoleLogDto>();
            }
            this.consoleLogs.add(consoleLog);
        }
    }

    public RequestExecution getRequestExecution() {
        return this.requestExecution;
    }

    public HistoryRequestBody getRequestBody() {
        return this.requestBody;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public ErrorResponseSerializable getErrorMessage() {
        return this.errorMessage;
    }

    public String getRequestPreScript() {
        return this.requestPreScript;
    }

    public String getRequestPostScript() {
        return this.requestPostScript;
    }

    public List<TestStatus> getRequestTests() {
        return this.requestTests;
    }

    public List<ConsoleLogDto> getConsoleLogs() {
        return this.consoleLogs;
    }

    public List<ContextVariable> getContextVariables() {
        return this.contextVariables;
    }

    public List<ResponseCookie> getCookies() {
        return this.cookies;
    }

    public HttpHeaderSaveRequest getCookieHeader() {
        return this.cookieHeader;
    }

    public byte[] getResponseBodyByte() {
        return this.responseBodyByte;
    }

    public void setRequestExecution(RequestExecution requestExecution) {
        this.requestExecution = requestExecution;
    }

    public void setRequestBody(HistoryRequestBody requestBody) {
        this.requestBody = requestBody;
    }

    public void setResponseBody(String responseBody) {
        this.responseBody = responseBody;
    }

    public void setErrorMessage(ErrorResponseSerializable errorMessage) {
        this.errorMessage = errorMessage;
    }

    public void setRequestPreScript(String requestPreScript) {
        this.requestPreScript = requestPreScript;
    }

    public void setRequestPostScript(String requestPostScript) {
        this.requestPostScript = requestPostScript;
    }

    public void setRequestTests(List<TestStatus> requestTests) {
        this.requestTests = requestTests;
    }

    public void setConsoleLogs(List<ConsoleLogDto> consoleLogs) {
        this.consoleLogs = consoleLogs;
    }

    public void setContextVariables(List<ContextVariable> contextVariables) {
        this.contextVariables = contextVariables;
    }

    public void setCookies(List<ResponseCookie> cookies) {
        this.cookies = cookies;
    }

    public void setCookieHeader(HttpHeaderSaveRequest cookieHeader) {
        this.cookieHeader = cookieHeader;
    }

    public void setResponseBodyByte(byte[] responseBodyByte) {
        this.responseBodyByte = responseBodyByte;
    }

    @Override
    public String toString() {
        return "RequestExecutionDetails(requestExecution=" + this.getRequestExecution() + ", requestBody=" + this.getRequestBody() + ", responseBody=" + this.getResponseBody() + ", errorMessage=" + this.getErrorMessage() + ", requestPreScript=" + this.getRequestPreScript() + ", requestPostScript=" + this.getRequestPostScript() + ", requestTests=" + this.getRequestTests() + ", consoleLogs=" + this.getConsoleLogs() + ", contextVariables=" + this.getContextVariables() + ", cookies=" + this.getCookies() + ", cookieHeader=" + this.getCookieHeader() + ", responseBodyByte=" + Arrays.toString(this.getResponseBodyByte()) + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestExecutionDetails)) {
            return false;
        }
        RequestExecutionDetails other = (RequestExecutionDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        RequestExecution this$requestExecution = this.getRequestExecution();
        RequestExecution other$requestExecution = other.getRequestExecution();
        if (this$requestExecution == null ? other$requestExecution != null : !((Object)this$requestExecution).equals(other$requestExecution)) {
            return false;
        }
        HistoryRequestBody this$requestBody = this.getRequestBody();
        HistoryRequestBody other$requestBody = other.getRequestBody();
        if (this$requestBody == null ? other$requestBody != null : !((Object)this$requestBody).equals(other$requestBody)) {
            return false;
        }
        String this$responseBody = this.getResponseBody();
        String other$responseBody = other.getResponseBody();
        if (this$responseBody == null ? other$responseBody != null : !this$responseBody.equals(other$responseBody)) {
            return false;
        }
        ErrorResponseSerializable this$errorMessage = this.getErrorMessage();
        ErrorResponseSerializable other$errorMessage = other.getErrorMessage();
        if (this$errorMessage == null ? other$errorMessage != null : !((Object)this$errorMessage).equals(other$errorMessage)) {
            return false;
        }
        String this$requestPreScript = this.getRequestPreScript();
        String other$requestPreScript = other.getRequestPreScript();
        if (this$requestPreScript == null ? other$requestPreScript != null : !this$requestPreScript.equals(other$requestPreScript)) {
            return false;
        }
        String this$requestPostScript = this.getRequestPostScript();
        String other$requestPostScript = other.getRequestPostScript();
        if (this$requestPostScript == null ? other$requestPostScript != null : !this$requestPostScript.equals(other$requestPostScript)) {
            return false;
        }
        List<TestStatus> this$requestTests = this.getRequestTests();
        List<TestStatus> other$requestTests = other.getRequestTests();
        if (this$requestTests == null ? other$requestTests != null : !((Object)this$requestTests).equals(other$requestTests)) {
            return false;
        }
        List<ConsoleLogDto> this$consoleLogs = this.getConsoleLogs();
        List<ConsoleLogDto> other$consoleLogs = other.getConsoleLogs();
        if (this$consoleLogs == null ? other$consoleLogs != null : !((Object)this$consoleLogs).equals(other$consoleLogs)) {
            return false;
        }
        List<ContextVariable> this$contextVariables = this.getContextVariables();
        List<ContextVariable> other$contextVariables = other.getContextVariables();
        if (this$contextVariables == null ? other$contextVariables != null : !((Object)this$contextVariables).equals(other$contextVariables)) {
            return false;
        }
        List<ResponseCookie> this$cookies = this.getCookies();
        List<ResponseCookie> other$cookies = other.getCookies();
        if (this$cookies == null ? other$cookies != null : !((Object)this$cookies).equals(other$cookies)) {
            return false;
        }
        HttpHeaderSaveRequest this$cookieHeader = this.getCookieHeader();
        HttpHeaderSaveRequest other$cookieHeader = other.getCookieHeader();
        if (this$cookieHeader == null ? other$cookieHeader != null : !((Object)this$cookieHeader).equals(other$cookieHeader)) {
            return false;
        }
        return Arrays.equals(this.getResponseBodyByte(), other.getResponseBodyByte());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof RequestExecutionDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        RequestExecution $requestExecution = this.getRequestExecution();
        result = result * 59 + ($requestExecution == null ? 43 : ((Object)$requestExecution).hashCode());
        HistoryRequestBody $requestBody = this.getRequestBody();
        result = result * 59 + ($requestBody == null ? 43 : ((Object)$requestBody).hashCode());
        String $responseBody = this.getResponseBody();
        result = result * 59 + ($responseBody == null ? 43 : $responseBody.hashCode());
        ErrorResponseSerializable $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : ((Object)$errorMessage).hashCode());
        String $requestPreScript = this.getRequestPreScript();
        result = result * 59 + ($requestPreScript == null ? 43 : $requestPreScript.hashCode());
        String $requestPostScript = this.getRequestPostScript();
        result = result * 59 + ($requestPostScript == null ? 43 : $requestPostScript.hashCode());
        List<TestStatus> $requestTests = this.getRequestTests();
        result = result * 59 + ($requestTests == null ? 43 : ((Object)$requestTests).hashCode());
        List<ConsoleLogDto> $consoleLogs = this.getConsoleLogs();
        result = result * 59 + ($consoleLogs == null ? 43 : ((Object)$consoleLogs).hashCode());
        List<ContextVariable> $contextVariables = this.getContextVariables();
        result = result * 59 + ($contextVariables == null ? 43 : ((Object)$contextVariables).hashCode());
        List<ResponseCookie> $cookies = this.getCookies();
        result = result * 59 + ($cookies == null ? 43 : ((Object)$cookies).hashCode());
        HttpHeaderSaveRequest $cookieHeader = this.getCookieHeader();
        result = result * 59 + ($cookieHeader == null ? 43 : ((Object)$cookieHeader).hashCode());
        result = result * 59 + Arrays.hashCode(this.getResponseBodyByte());
        return result;
    }
}

