/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.history;

import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Table;
import org.qubership.atp.itf.lite.backend.enums.TestingStatus;
import org.qubership.atp.itf.lite.backend.model.entities.AbstractEntity;

@Entity
@Table(name="testing_statuses")
public class TestStatus
extends AbstractEntity {
    @Column(name="name")
    private String name;
    @Column(name="status")
    @Enumerated(value=EnumType.STRING)
    private TestingStatus status;
    @Column(name="error_message", columnDefinition="TEXT")
    private String errorMessage;

    public TestStatus(UUID id, String name, TestingStatus status, String errorMessage) {
        this.id = id;
        this.name = name;
        this.status = status;
        this.errorMessage = errorMessage;
    }

    public TestStatus(String name, TestingStatus status, String errorMessage) {
        this(null, name, status, errorMessage);
    }

    public TestStatus(String name, TestingStatus status) {
        this(null, name, status, null);
    }

    public String getName() {
        return this.name;
    }

    public TestingStatus getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(TestingStatus status) {
        this.status = status;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TestStatus)) {
            return false;
        }
        TestStatus other = (TestStatus)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        TestingStatus this$status = this.getStatus();
        TestingStatus other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)((Object)this$status)).equals((Object)other$status)) {
            return false;
        }
        String this$errorMessage = this.getErrorMessage();
        String other$errorMessage = other.getErrorMessage();
        return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof TestStatus;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        TestingStatus $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)((Object)$status)).hashCode());
        String $errorMessage = this.getErrorMessage();
        result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "TestStatus(name=" + this.getName() + ", status=" + (Object)((Object)this.getStatus()) + ", errorMessage=" + this.getErrorMessage() + ")";
    }

    public TestStatus() {
    }
}

