/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.http;

import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.javers.core.metamodel.annotation.DiffInclude;
import org.qubership.atp.itf.lite.backend.model.api.request.http.HttpHeaderSaveRequest;
import org.qubership.atp.itf.lite.backend.model.entities.Request;
import org.qubership.atp.itf.lite.backend.model.entities.RequestBody;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestHeader;
import org.qubership.atp.itf.lite.backend.model.entities.http.RequestParam;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpMethod;

@Entity
@Table(name="HTTP_REQUESTS")
public class HttpRequest
extends Request {
    @Enumerated(value=EnumType.STRING)
    @Column(name="http_method")
    @DiffInclude
    private HttpMethod httpMethod;
    @Column(name="url")
    @DiffInclude
    private String url;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="request_id")
    @DiffInclude
    private List<RequestParam> requestParams;
    @OneToMany(cascade={CascadeType.ALL})
    @JoinColumn(name="request_id")
    @DiffInclude
    private List<RequestHeader> requestHeaders;
    @Embedded
    @DiffInclude
    private RequestBody body;
    @Transient
    private HttpHeaderSaveRequest cookieHeader;

    public HttpRequest(HttpRequest httpRequest) {
        super(httpRequest);
        this.httpMethod = httpRequest.getHttpMethod();
        this.url = httpRequest.getUrl();
        this.requestParams = httpRequest.getRequestParams();
        this.requestHeaders = httpRequest.getRequestHeaders();
        this.body = httpRequest.getBody();
        this.cookieHeader = httpRequest.getCookieHeader();
    }

    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    public String getUrl() {
        return this.url;
    }

    public List<RequestParam> getRequestParams() {
        return this.requestParams;
    }

    public List<RequestHeader> getRequestHeaders() {
        return this.requestHeaders;
    }

    public RequestBody getBody() {
        return this.body;
    }

    public HttpHeaderSaveRequest getCookieHeader() {
        return this.cookieHeader;
    }

    public void setHttpMethod(HttpMethod httpMethod) {
        this.httpMethod = httpMethod;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setRequestParams(List<RequestParam> requestParams) {
        this.requestParams = requestParams;
    }

    public void setRequestHeaders(List<RequestHeader> requestHeaders) {
        this.requestHeaders = requestHeaders;
    }

    public void setBody(RequestBody body) {
        this.body = body;
    }

    public void setCookieHeader(HttpHeaderSaveRequest cookieHeader) {
        this.cookieHeader = cookieHeader;
    }

    @Override
    public String toString() {
        return "HttpRequest(httpMethod=" + (Object)((Object)this.getHttpMethod()) + ", url=" + this.getUrl() + ", requestParams=" + this.getRequestParams() + ", requestHeaders=" + this.getRequestHeaders() + ", body=" + this.getBody() + ", cookieHeader=" + this.getCookieHeader() + ")";
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        HttpMethod this$httpMethod = this.getHttpMethod();
        HttpMethod other$httpMethod = other.getHttpMethod();
        if (this$httpMethod == null ? other$httpMethod != null : !((Object)((Object)this$httpMethod)).equals((Object)other$httpMethod)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        List<RequestParam> this$requestParams = this.getRequestParams();
        List<RequestParam> other$requestParams = other.getRequestParams();
        if (this$requestParams == null ? other$requestParams != null : !((Object)this$requestParams).equals(other$requestParams)) {
            return false;
        }
        List<RequestHeader> this$requestHeaders = this.getRequestHeaders();
        List<RequestHeader> other$requestHeaders = other.getRequestHeaders();
        if (this$requestHeaders == null ? other$requestHeaders != null : !((Object)this$requestHeaders).equals(other$requestHeaders)) {
            return false;
        }
        RequestBody this$body = this.getBody();
        RequestBody other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        HttpHeaderSaveRequest this$cookieHeader = this.getCookieHeader();
        HttpHeaderSaveRequest other$cookieHeader = other.getCookieHeader();
        return !(this$cookieHeader == null ? other$cookieHeader != null : !((Object)this$cookieHeader).equals(other$cookieHeader));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        HttpMethod $httpMethod = this.getHttpMethod();
        result = result * 59 + ($httpMethod == null ? 43 : ((Object)((Object)$httpMethod)).hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        List<RequestParam> $requestParams = this.getRequestParams();
        result = result * 59 + ($requestParams == null ? 43 : ((Object)$requestParams).hashCode());
        List<RequestHeader> $requestHeaders = this.getRequestHeaders();
        result = result * 59 + ($requestHeaders == null ? 43 : ((Object)$requestHeaders).hashCode());
        RequestBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        HttpHeaderSaveRequest $cookieHeader = this.getCookieHeader();
        result = result * 59 + ($cookieHeader == null ? 43 : ((Object)$cookieHeader).hashCode());
        return result;
    }

    public HttpRequest() {
    }
}

