/*
 * Decompiled with CFR 0.152.
 */
package org.qubership.atp.itf.lite.backend.model.entities.http.methods;

import org.apache.commons.lang3.EnumUtils;
import org.apache.http.client.methods.HttpRequestBase;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpCopy;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpDelete;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpGet;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpHead;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpLink;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpLock;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpOptions;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpPatch;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpPost;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpPropfind;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpPurge;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpPut;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpTrace;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpUnlink;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpUnlock;
import org.qubership.atp.itf.lite.backend.model.entities.http.methods.HttpView;
import org.springframework.lang.Nullable;

public enum HttpMethod {
    GET(HttpGet.class),
    HEAD(HttpHead.class),
    POST(HttpPost.class),
    PUT(HttpPut.class),
    PATCH(HttpPatch.class),
    DELETE(HttpDelete.class),
    OPTIONS(HttpOptions.class),
    TRACE(HttpTrace.class),
    COPY(HttpCopy.class),
    LOCK(HttpLock.class),
    UNLOCK(HttpUnlock.class),
    PROPFIND(HttpPropfind.class),
    PURGE(HttpPurge.class),
    LINK(HttpLink.class),
    UNLINK(HttpUnlink.class),
    VIEW(HttpView.class);

    private final Class<? extends HttpRequestBase> methodClass;

    private HttpMethod(Class<? extends HttpRequestBase> httpMethodClass) {
        this.methodClass = httpMethodClass;
    }

    public HttpRequestBase getHttpRequest(String url) throws Exception {
        return this.methodClass.getConstructor(String.class).newInstance(url);
    }

    @Nullable
    public static HttpMethod resolve(@Nullable String method) {
        return (HttpMethod)EnumUtils.getEnum(HttpMethod.class, (String)method, null);
    }

    public String toString() {
        return this.name();
    }
}

